'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var cov_129yad3bqp = function () {
  var path = '/Users/gajuskuizinas/Documents/dev/gajus/table/src/createStream.js',
      hash = '010614a23f3df4b4d26327499bc89f0103d53217',
      global = new Function('return this')(),
      gcv = '__coverage__',
      coverageData = {
    path: '/Users/gajuskuizinas/Documents/dev/gajus/table/src/createStream.js',
    statementMap: {
      '0': {
        start: {
          line: 21,
          column: 20
        },
        end: {
          line: 35,
          column: 1
        }
      },
      '1': {
        start: {
          line: 24,
          column: 2
        },
        end: {
          line: 24,
          column: 34
        }
      },
      '2': {
        start: {
          line: 26,
          column: 2
        },
        end: {
          line: 26,
          column: 41
        }
      },
      '3': {
        start: {
          line: 28,
          column: 25
        },
        end: {
          line: 28,
          column: 62
        }
      },
      '4': {
        start: {
          line: 30,
          column: 2
        },
        end: {
          line: 30,
          column: 66
        }
      },
      '5': {
        start: {
          line: 31,
          column: 2
        },
        end: {
          line: 31,
          column: 38
        }
      },
      '6': {
        start: {
          line: 32,
          column: 2
        },
        end: {
          line: 32,
          column: 36
        }
      },
      '7': {
        start: {
          line: 34,
          column: 2
        },
        end: {
          line: 34,
          column: 14
        }
      },
      '8': {
        start: {
          line: 43,
          column: 15
        },
        end: {
          line: 61,
          column: 1
        }
      },
      '9': {
        start: {
          line: 44,
          column: 15
        },
        end: {
          line: 44,
          column: 41
        }
      },
      '10': {
        start: {
          line: 46,
          column: 15
        },
        end: {
          line: 48,
          column: 13
        }
      },
      '11': {
        start: {
          line: 47,
          column: 4
        },
        end: {
          line: 47,
          column: 46
        }
      },
      '12': {
        start: {
          line: 52,
          column: 2
        },
        end: {
          line: 52,
          column: 14
        }
      },
      '13': {
        start: {
          line: 54,
          column: 2
        },
        end: {
          line: 54,
          column: 59
        }
      },
      '14': {
        start: {
          line: 55,
          column: 2
        },
        end: {
          line: 55,
          column: 17
        }
      },
      '15': {
        start: {
          line: 56,
          column: 2
        },
        end: {
          line: 56,
          column: 62
        }
      },
      '16': {
        start: {
          line: 58,
          column: 2
        },
        end: {
          line: 58,
          column: 29
        }
      },
      '17': {
        start: {
          line: 60,
          column: 2
        },
        end: {
          line: 60,
          column: 31
        }
      },
      '18': {
        start: {
          line: 69,
          column: 15
        },
        end: {
          line: 87,
          column: 1
        }
      },
      '19': {
        start: {
          line: 70,
          column: 15
        },
        end: {
          line: 70,
          column: 41
        }
      },
      '20': {
        start: {
          line: 72,
          column: 15
        },
        end: {
          line: 74,
          column: 13
        }
      },
      '21': {
        start: {
          line: 73,
          column: 4
        },
        end: {
          line: 73,
          column: 46
        }
      },
      '22': {
        start: {
          line: 78,
          column: 2
        },
        end: {
          line: 78,
          column: 22
        }
      },
      '23': {
        start: {
          line: 80,
          column: 2
        },
        end: {
          line: 80,
          column: 60
        }
      },
      '24': {
        start: {
          line: 81,
          column: 2
        },
        end: {
          line: 81,
          column: 17
        }
      },
      '25': {
        start: {
          line: 82,
          column: 2
        },
        end: {
          line: 82,
          column: 62
        }
      },
      '26': {
        start: {
          line: 84,
          column: 2
        },
        end: {
          line: 84,
          column: 29
        }
      },
      '27': {
        start: {
          line: 86,
          column: 2
        },
        end: {
          line: 86,
          column: 31
        }
      },
      '28': {
        start: {
          line: 94,
          column: 17
        },
        end: {
          line: 94,
          column: 45
        }
      },
      '29': {
        start: {
          line: 96,
          column: 27
        },
        end: {
          line: 98,
          column: 4
        }
      },
      '30': {
        start: {
          line: 97,
          column: 4
        },
        end: {
          line: 97,
          column: 67
        }
      },
      '31': {
        start: {
          line: 102,
          column: 2
        },
        end: {
          line: 102,
          column: 15
        }
      },
      '32': {
        start: {
          line: 104,
          column: 2
        },
        end: {
          line: 122,
          column: 4
        }
      },
      '33': {
        start: {
          line: 110,
          column: 6
        },
        end: {
          line: 112,
          column: 7
        }
      },
      '34': {
        start: {
          line: 111,
          column: 8
        },
        end: {
          line: 111,
          column: 81
        }
      },
      '35': {
        start: {
          line: 114,
          column: 6
        },
        end: {
          line: 120,
          column: 7
        }
      },
      '36': {
        start: {
          line: 115,
          column: 8
        },
        end: {
          line: 115,
          column: 22
        }
      },
      '37': {
        start: {
          line: 117,
          column: 8
        },
        end: {
          line: 117,
          column: 53
        }
      },
      '38': {
        start: {
          line: 119,
          column: 8
        },
        end: {
          line: 119,
          column: 53
        }
      }
    },
    fnMap: {
      '0': {
        name: '(anonymous_0)',
        decl: {
          start: {
            line: 21,
            column: 20
          },
          end: {
            line: 21,
            column: 21
          }
        },
        loc: {
          start: {
            line: 21,
            column: 38
          },
          end: {
            line: 35,
            column: 1
          }
        }
      },
      '1': {
        name: '(anonymous_1)',
        decl: {
          start: {
            line: 43,
            column: 15
          },
          end: {
            line: 43,
            column: 16
          }
        },
        loc: {
          start: {
            line: 43,
            column: 50
          },
          end: {
            line: 61,
            column: 1
          }
        }
      },
      '2': {
        name: '(anonymous_2)',
        decl: {
          start: {
            line: 46,
            column: 27
          },
          end: {
            line: 46,
            column: 28
          }
        },
        loc: {
          start: {
            line: 46,
            column: 43
          },
          end: {
            line: 48,
            column: 3
          }
        }
      },
      '3': {
        name: '(anonymous_3)',
        decl: {
          start: {
            line: 69,
            column: 15
          },
          end: {
            line: 69,
            column: 16
          }
        },
        loc: {
          start: {
            line: 69,
            column: 50
          },
          end: {
            line: 87,
            column: 1
          }
        }
      },
      '4': {
        name: '(anonymous_4)',
        decl: {
          start: {
            line: 72,
            column: 27
          },
          end: {
            line: 72,
            column: 28
          }
        },
        loc: {
          start: {
            line: 72,
            column: 43
          },
          end: {
            line: 74,
            column: 3
          }
        }
      },
      '5': {
        name: '(anonymous_5)',
        decl: {
          start: {
            line: 93,
            column: 15
          },
          end: {
            line: 93,
            column: 16
          }
        },
        loc: {
          start: {
            line: 93,
            column: 36
          },
          end: {
            line: 123,
            column: 1
          }
        }
      },
      '6': {
        name: '(anonymous_6)',
        decl: {
          start: {
            line: 96,
            column: 55
          },
          end: {
            line: 96,
            column: 56
          }
        },
        loc: {
          start: {
            line: 96,
            column: 67
          },
          end: {
            line: 98,
            column: 3
          }
        }
      },
      '7': {
        name: '(anonymous_7)',
        decl: {
          start: {
            line: 109,
            column: 11
          },
          end: {
            line: 109,
            column: 12
          }
        },
        loc: {
          start: {
            line: 109,
            column: 20
          },
          end: {
            line: 121,
            column: 5
          }
        }
      }
    },
    branchMap: {
      '0': {
        loc: {
          start: {
            line: 93,
            column: 16
          },
          end: {
            line: 93,
            column: 31
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 93,
            column: 29
          },
          end: {
            line: 93,
            column: 31
          }
        }]
      },
      '1': {
        loc: {
          start: {
            line: 110,
            column: 6
          },
          end: {
            line: 112,
            column: 7
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 110,
            column: 6
          },
          end: {
            line: 112,
            column: 7
          }
        }, {
          start: {
            line: 110,
            column: 6
          },
          end: {
            line: 112,
            column: 7
          }
        }]
      },
      '2': {
        loc: {
          start: {
            line: 114,
            column: 6
          },
          end: {
            line: 120,
            column: 7
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 114,
            column: 6
          },
          end: {
            line: 120,
            column: 7
          }
        }, {
          start: {
            line: 114,
            column: 6
          },
          end: {
            line: 120,
            column: 7
          }
        }]
      }
    },
    s: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0,
      '8': 0,
      '9': 0,
      '10': 0,
      '11': 0,
      '12': 0,
      '13': 0,
      '14': 0,
      '15': 0,
      '16': 0,
      '17': 0,
      '18': 0,
      '19': 0,
      '20': 0,
      '21': 0,
      '22': 0,
      '23': 0,
      '24': 0,
      '25': 0,
      '26': 0,
      '27': 0,
      '28': 0,
      '29': 0,
      '30': 0,
      '31': 0,
      '32': 0,
      '33': 0,
      '34': 0,
      '35': 0,
      '36': 0,
      '37': 0,
      '38': 0
    },
    f: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0
    },
    b: {
      '0': [0],
      '1': [0, 0],
      '2': [0, 0]
    }
  },
      coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  coverageData.hash = hash;
  return coverage[path] = coverageData;
}();

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _makeStreamConfig = require('./makeStreamConfig');

var _makeStreamConfig2 = _interopRequireDefault(_makeStreamConfig);

var _drawRow = require('./drawRow');

var _drawRow2 = _interopRequireDefault(_drawRow);

var _drawBorder = require('./drawBorder');

var _stringifyTableData = require('./stringifyTableData');

var _stringifyTableData2 = _interopRequireDefault(_stringifyTableData);

var _truncateTableData = require('./truncateTableData');

var _truncateTableData2 = _interopRequireDefault(_truncateTableData);

var _mapDataUsingRowHeightIndex = require('./mapDataUsingRowHeightIndex');

var _mapDataUsingRowHeightIndex2 = _interopRequireDefault(_mapDataUsingRowHeightIndex);

var _alignTableData = require('./alignTableData');

var _alignTableData2 = _interopRequireDefault(_alignTableData);

var _padTableData = require('./padTableData');

var _padTableData2 = _interopRequireDefault(_padTableData);

var _calculateRowHeightIndex = require('./calculateRowHeightIndex');

var _calculateRowHeightIndex2 = _interopRequireDefault(_calculateRowHeightIndex);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @param {Array} data
 * @param {Object} config
 * @returns {Array}
 */
const prepareData = (++cov_129yad3bqp.s[0], (data, config) => {
  ++cov_129yad3bqp.f[0];

  let rows;

  ++cov_129yad3bqp.s[1];
  rows = (0, _stringifyTableData2.default)(data);

  ++cov_129yad3bqp.s[2];
  rows = (0, _truncateTableData2.default)(data, config);

  const rowHeightIndex = (++cov_129yad3bqp.s[3], (0, _calculateRowHeightIndex2.default)(rows, config));

  ++cov_129yad3bqp.s[4];
  rows = (0, _mapDataUsingRowHeightIndex2.default)(rows, rowHeightIndex, config);
  ++cov_129yad3bqp.s[5];
  rows = (0, _alignTableData2.default)(rows, config);
  ++cov_129yad3bqp.s[6];
  rows = (0, _padTableData2.default)(rows, config);

  ++cov_129yad3bqp.s[7];
  return rows;
});

/**
 * @param {string[]} row
 * @param {number[]} columnWidthIndex
 * @param {Object} config
 * @returns {undefined}
 */
const create = (++cov_129yad3bqp.s[8], (row, columnWidthIndex, config) => {
  ++cov_129yad3bqp.f[1];

  const rows = (++cov_129yad3bqp.s[9], prepareData([row], config));

  const body = (++cov_129yad3bqp.s[10], _lodash2.default.map(rows, literalRow => {
    ++cov_129yad3bqp.f[2];
    ++cov_129yad3bqp.s[11];

    return (0, _drawRow2.default)(literalRow, config.border);
  }).join(''));

  let output;

  ++cov_129yad3bqp.s[12];
  output = '';

  ++cov_129yad3bqp.s[13];
  output += (0, _drawBorder.drawBorderTop)(columnWidthIndex, config.border);
  ++cov_129yad3bqp.s[14];
  output += body;
  ++cov_129yad3bqp.s[15];
  output += (0, _drawBorder.drawBorderBottom)(columnWidthIndex, config.border);

  ++cov_129yad3bqp.s[16];
  output = _lodash2.default.trimEnd(output);

  ++cov_129yad3bqp.s[17];
  process.stdout.write(output);
});

/**
 * @param {string[]} row
 * @param {number[]} columnWidthIndex
 * @param {Object} config
 * @returns {undefined}
 */
const append = (++cov_129yad3bqp.s[18], (row, columnWidthIndex, config) => {
  ++cov_129yad3bqp.f[3];

  const rows = (++cov_129yad3bqp.s[19], prepareData([row], config));

  const body = (++cov_129yad3bqp.s[20], _lodash2.default.map(rows, literalRow => {
    ++cov_129yad3bqp.f[4];
    ++cov_129yad3bqp.s[21];

    return (0, _drawRow2.default)(literalRow, config.border);
  }).join(''));

  let output;

  ++cov_129yad3bqp.s[22];
  output = '\r\x1b[K';

  ++cov_129yad3bqp.s[23];
  output += (0, _drawBorder.drawBorderJoin)(columnWidthIndex, config.border);
  ++cov_129yad3bqp.s[24];
  output += body;
  ++cov_129yad3bqp.s[25];
  output += (0, _drawBorder.drawBorderBottom)(columnWidthIndex, config.border);

  ++cov_129yad3bqp.s[26];
  output = _lodash2.default.trimEnd(output);

  ++cov_129yad3bqp.s[27];
  process.stdout.write(output);
});

/**
 * @param {Object} userConfig
 * @returns {Object}
 */

exports.default = function () {
  let userConfig = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : (++cov_129yad3bqp.b[0][0], {});
  ++cov_129yad3bqp.f[5];

  const config = (++cov_129yad3bqp.s[28], (0, _makeStreamConfig2.default)(userConfig));

  const columnWidthIndex = (++cov_129yad3bqp.s[29], _lodash2.default.mapValues(config.columns, column => {
    ++cov_129yad3bqp.f[6];
    ++cov_129yad3bqp.s[30];

    return column.width + column.paddingLeft + column.paddingRight;
  }));

  let empty;

  ++cov_129yad3bqp.s[31];
  empty = true;

  ++cov_129yad3bqp.s[32];
  return {
    /**
     * @param {string[]} row
     * @returns {undefined}
     */
    write: row => {
      ++cov_129yad3bqp.f[7];
      ++cov_129yad3bqp.s[33];

      if (row.length !== config.columnCount) {
        ++cov_129yad3bqp.b[1][0];
        ++cov_129yad3bqp.s[34];

        throw new Error('Row cell count does not match the config.columnCount.');
      } else {
        ++cov_129yad3bqp.b[1][1];
      }

      ++cov_129yad3bqp.s[35];
      if (empty) {
        ++cov_129yad3bqp.b[2][0];
        ++cov_129yad3bqp.s[36];

        empty = false;

        ++cov_129yad3bqp.s[37];
        return create(row, columnWidthIndex, config);
      } else {
        ++cov_129yad3bqp.b[2][1];
        ++cov_129yad3bqp.s[38];

        return append(row, columnWidthIndex, config);
      }
    }
  };
};

module.exports = exports['default'];