/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxDecompiler;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.core.codegen.CodeWriter;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.InputFile;
import jadx.core.xmlgen.ResTableParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourcesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesLoader.class);
    private static final int READ_BUFFER_SIZE = 8192;
    private static final int LOAD_SIZE_LIMIT = 0xA00000;
    private final JadxDecompiler jadxRef;

    ResourcesLoader(JadxDecompiler jadxRef) {
        this.jadxRef = jadxRef;
    }

    List<ResourceFile> load(List<InputFile> inputFiles) {
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>(inputFiles.size());
        for (InputFile file : inputFiles) {
            this.loadFile(list, file.getFile());
        }
        return list;
    }

    public static Object decodeStream(ResourceFile rf, ResourceDecoder decoder) throws JadxException {
        ResourceFile.ZipRef zipRef = rf.getZipRef();
        if (zipRef == null) {
            return null;
        }
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(zipRef.getZipFile());
            ZipEntry entry = zipFile.getEntry(zipRef.getEntryName());
            if (entry == null) {
                throw new IOException("Zip entry not found: " + zipRef);
            }
            inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
            Object object = decoder.decode(entry.getSize(), inputStream);
            return object;
        }
        catch (Exception e) {
            throw new JadxException("Error decode: " + zipRef.getEntryName(), e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                LOG.debug("Error close zip file: {}", (Object)zipRef, (Object)e);
            }
        }
    }

    static CodeWriter loadContent(final JadxDecompiler jadxRef, final ResourceFile rf) {
        try {
            return (CodeWriter)ResourcesLoader.decodeStream(rf, new ResourceDecoder(){

                @Override
                public Object decode(long size, InputStream is) throws IOException {
                    if (size > 0xA00000L) {
                        return new CodeWriter().add("File too big, size: " + String.format("%.2f KB", (double)size / 1024.0));
                    }
                    return ResourcesLoader.loadContent(jadxRef, rf.getType(), is);
                }
            });
        }
        catch (JadxException e) {
            LOG.error("Decode error", (Throwable)e);
            CodeWriter cw = new CodeWriter();
            cw.add("Error decode ").add(rf.getType().toString().toLowerCase());
            cw.startLine(Utils.getStackTrace(e.getCause()));
            return cw;
        }
    }

    private static CodeWriter loadContent(JadxDecompiler jadxRef, ResourceType type, InputStream inputStream) throws IOException {
        switch (type) {
            case MANIFEST: 
            case XML: {
                return jadxRef.getXmlParser().parse(inputStream);
            }
            case ARSC: {
                return new ResTableParser().decodeToCodeWriter(inputStream);
            }
        }
        return ResourcesLoader.loadToCodeWriter(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(List<ResourceFile> list, File file) {
        if (file == null) {
            return;
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.addEntry(list, file, entry);
            }
        }
        catch (IOException e) {
            LOG.debug("Not a zip file: {}", (Object)file.getAbsolutePath());
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception e) {
                    LOG.error("Zip file close error: {}", (Object)file.getAbsolutePath(), (Object)e);
                }
            }
        }
    }

    private void addEntry(List<ResourceFile> list, File zipFile, ZipEntry entry) {
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        ResourceType type = ResourceType.getFileType(name);
        ResourceFile rf = new ResourceFile(this.jadxRef, name, type);
        rf.setZipRef(new ResourceFile.ZipRef(zipFile, name));
        list.add(rf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CodeWriter loadToCodeWriter(InputStream is) throws IOException {
        CodeWriter cw = new CodeWriter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        byte[] buffer = new byte[8192];
        try {
            int count;
            while ((count = is.read(buffer)) != -1) {
                baos.write(buffer, 0, count);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        cw.add(baos.toString("UTF-8"));
        return cw;
    }

    public static interface ResourceDecoder {
        public Object decode(long var1, InputStream var3) throws IOException;
    }
}

