/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayReadDenormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadNormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadSliceDenormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadSliceNormalizedNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.literal.IntegerFixnumLiteralNode;

public abstract class PrimitiveArrayNodeFactory {
    public static RubyNode read(RubyContext context, SourceSection sourceSection, RubyNode array, int index) {
        IntegerFixnumLiteralNode literalIndex = new IntegerFixnumLiteralNode(context, sourceSection, index);
        if (index >= 0) {
            return ArrayReadNormalizedNodeGen.create(context, sourceSection, array, literalIndex);
        }
        return ArrayReadDenormalizedNodeGen.create(context, sourceSection, array, literalIndex);
    }

    public static RubyNode readSlice(RubyContext context, SourceSection sourceSection, RubyNode array, int start, int exclusiveEnd) {
        IntegerFixnumLiteralNode literalStart = new IntegerFixnumLiteralNode(context, sourceSection, start);
        IntegerFixnumLiteralNode literalExclusiveEnd = new IntegerFixnumLiteralNode(context, sourceSection, exclusiveEnd);
        if (start >= 0 && exclusiveEnd >= 0) {
            return ArrayReadSliceNormalizedNodeGen.create(context, sourceSection, array, literalStart, literalExclusiveEnd);
        }
        return ArrayReadSliceDenormalizedNodeGen.create(context, sourceSection, array, literalStart, literalExclusiveEnd);
    }
}

