/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class FileLoginModule
implements LoginModule {
    private static final String DEFAULT_PASSWORD_FILE_NAME = AccessController.doPrivileged(new GetPropertyAction("java.home")) + File.separatorChar + "lib" + File.separatorChar + "management" + File.separatorChar + "jmxremote.password";
    private static final String USERNAME_KEY = "javax.security.auth.login.name";
    private static final String PASSWORD_KEY = "javax.security.auth.login.password";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "FileLoginModule");
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private JMXPrincipal user;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> sharedState;
    private Map<String, ?> options;
    private String passwordFile;
    private String passwordFileDisplayName;
    private boolean userSuppliedPasswordFile;
    private boolean hasJavaHomePermission;
    private Properties userCredentials;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = (Map)Util.cast(sharedState);
        this.options = options;
        this.tryFirstPass = "true".equalsIgnoreCase((String)options.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)options.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)options.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)options.get("clearPass"));
        this.passwordFileDisplayName = this.passwordFile = (String)options.get("passwordFile");
        this.userSuppliedPasswordFile = true;
        if (this.passwordFile == null) {
            this.passwordFile = DEFAULT_PASSWORD_FILE_NAME;
            this.userSuppliedPasswordFile = false;
            try {
                System.getProperty("java.home");
                this.hasJavaHomePermission = true;
                this.passwordFileDisplayName = this.passwordFile;
            }
            catch (SecurityException e) {
                this.hasJavaHomePermission = false;
                this.passwordFileDisplayName = "jmxremote.password";
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        try {
            this.loadPasswordFile();
        }
        catch (IOException ioe) {
            LoginException le = new LoginException("Error: unable to load the password file: " + this.passwordFileDisplayName);
            throw EnvHelp.initCause(le, ioe);
        }
        if (this.userCredentials == null) {
            throw new LoginException("Error: unable to locate the users' credentials.");
        }
        if (logger.debugOn()) {
            logger.debug("login", "Using password file: " + this.passwordFileDisplayName);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (logger.debugOn()) {
                    logger.debug("login", "Authentication using cached password has succeeded");
                }
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                logger.debug("login", "Authentication using cached password has failed");
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (logger.debugOn()) {
                    logger.debug("login", "Authentication using cached password has succeeded");
                }
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                logger.debug("login", "Authentication using cached password has failed");
                throw le;
            }
        }
        if (logger.debugOn()) {
            logger.debug("login", "Acquiring password");
        }
        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            if (logger.debugOn()) {
                logger.debug("login", "Authentication has succeeded");
            }
            return true;
        }
        catch (LoginException le) {
            this.cleanState();
            logger.debug("login", "Authentication has failed");
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        if (!this.subject.getPrincipals().contains(this.user)) {
            this.subject.getPrincipals().add(this.user);
        }
        if (logger.debugOn()) {
            logger.debug("commit", "Authentication has completed successfully");
        }
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (logger.debugOn()) {
            logger.debug("abort", "Authentication has not completed successfully");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanState();
            this.user = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        this.subject.getPrincipals().remove(this.user);
        this.cleanState();
        this.succeeded = false;
        this.commitSucceeded = false;
        this.user = null;
        if (logger.debugOn()) {
            logger.debug("logout", "Subject is being logged out");
        }
        return true;
    }

    private void attemptAuthentication(boolean usePasswdFromSharedState) throws LoginException {
        this.getUsernamePassword(usePasswdFromSharedState);
        String localPassword = this.userCredentials.getProperty(this.username);
        if (localPassword == null || !localPassword.equals(new String(this.password))) {
            if (logger.debugOn()) {
                logger.debug("login", "Invalid username or password");
            }
            throw new FailedLoginException("Invalid username or password");
        }
        if (this.storePass && !this.sharedState.containsKey(USERNAME_KEY) && !this.sharedState.containsKey(PASSWORD_KEY)) {
            this.sharedState.put(USERNAME_KEY, this.username);
            this.sharedState.put(PASSWORD_KEY, this.password);
        }
        this.user = new JMXPrincipal(this.username);
        if (logger.debugOn()) {
            logger.debug("login", "User '" + this.username + "' successfully validated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPasswordFile() throws IOException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.passwordFile);
        }
        catch (SecurityException e) {
            if (this.userSuppliedPasswordFile || this.hasJavaHomePermission) {
                throw e;
            }
            FilePermission fp = new FilePermission(this.passwordFileDisplayName, "read");
            AccessControlException ace = new AccessControlException("access denied " + fp.toString());
            ace.setStackTrace(e.getStackTrace());
            throw ace;
        }
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            this.userCredentials = new Properties();
            this.userCredentials.load(bis);
        }
        finally {
            fis.close();
        }
    }

    private void getUsernamePassword(boolean usePasswdFromSharedState) throws LoginException {
        if (usePasswdFromSharedState) {
            this.username = (String)this.sharedState.get(USERNAME_KEY);
            this.password = (char[])this.sharedState.get(PASSWORD_KEY);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("username"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            LoginException le = new LoginException(ioe.toString());
            throw EnvHelp.initCause(le, ioe);
        }
        catch (UnsupportedCallbackException uce) {
            LoginException le = new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication " + "information from the user");
            throw EnvHelp.initCause(le, uce);
        }
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
        if (this.clearPass) {
            this.sharedState.remove(USERNAME_KEY);
            this.sharedState.remove(PASSWORD_KEY);
        }
    }
}

