/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import sun.applet.AppletAudioClip;
import sun.applet.AppletEvent;
import sun.applet.AppletImageRef;
import sun.applet.AppletListener;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletPanel;
import sun.applet.AppletProps;
import sun.applet.AppletSecurity;
import sun.applet.AppletViewerFactory;
import sun.applet.AppletViewerPanel;
import sun.applet.Main;
import sun.applet.StdAppletViewerFactory;
import sun.applet.TextFrame;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.misc.Ref;

public class AppletViewer
extends Frame
implements AppletContext,
Printable {
    private static String defaultSaveFile = "Applet.ser";
    AppletViewerPanel panel;
    Label label;
    PrintStream statusMsgStream;
    AppletViewerFactory factory;
    private static Map audioClips = new HashMap();
    private static Map imageRefs = new HashMap();
    static Vector appletPanels = new Vector();
    static Hashtable systemParam = new Hashtable();
    static AppletProps props;
    static int c;
    private static int x;
    private static int y;
    private static final int XDELTA = 30;
    private static final int YDELTA = 30;
    static String encoding;
    private static AppletMessageHandler amh;

    public AppletViewer(int x, int y, URL doc, Hashtable atts, PrintStream statusMsgStream, AppletViewerFactory factory) {
        this.factory = factory;
        this.statusMsgStream = statusMsgStream;
        this.setTitle(amh.getMessage("tool.title", atts.get("code")));
        MenuBar mb = factory.getBaseMenuBar();
        Menu m = new Menu(amh.getMessage("menu.applet"));
        this.addMenuItem(m, "menuitem.restart");
        this.addMenuItem(m, "menuitem.reload");
        this.addMenuItem(m, "menuitem.stop");
        this.addMenuItem(m, "menuitem.save");
        this.addMenuItem(m, "menuitem.start");
        this.addMenuItem(m, "menuitem.clone");
        m.add(new MenuItem("-"));
        this.addMenuItem(m, "menuitem.tag");
        this.addMenuItem(m, "menuitem.info");
        this.addMenuItem(m, "menuitem.edit").disable();
        this.addMenuItem(m, "menuitem.encoding");
        m.add(new MenuItem("-"));
        this.addMenuItem(m, "menuitem.print");
        m.add(new MenuItem("-"));
        this.addMenuItem(m, "menuitem.props");
        m.add(new MenuItem("-"));
        this.addMenuItem(m, "menuitem.close");
        if (factory.isStandalone()) {
            this.addMenuItem(m, "menuitem.quit");
        }
        mb.add(m);
        this.setMenuBar(mb);
        this.panel = new AppletViewerPanel(doc, atts);
        this.add("Center", this.panel);
        this.label = new Label(amh.getMessage("label.hello"));
        this.add("South", this.label);
        this.panel.init();
        appletPanels.addElement(this.panel);
        this.pack();
        this.move(x, y);
        this.setVisible(true);
        WindowAdapter windowEventListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AppletViewer.this.appletClose();
            }

            @Override
            public void windowIconified(WindowEvent evt) {
                AppletViewer.this.appletStop();
            }

            @Override
            public void windowDeiconified(WindowEvent evt) {
                AppletViewer.this.appletStart();
            }
        };
        this.addWindowListener(windowEventListener);
        class AppletEventListener
        implements AppletListener {
            final Frame frame;

            public AppletEventListener(Frame frame) {
                this.frame = frame;
            }

            @Override
            public void appletStateChanged(AppletEvent evt) {
                AppletPanel src = (AppletPanel)evt.getSource();
                switch (evt.getID()) {
                    case 51234: {
                        if (src == null) break;
                        AppletViewer.this.resize(AppletViewer.this.preferredSize());
                        AppletViewer.this.validate();
                        break;
                    }
                    case 51236: {
                        Applet a = src.getApplet();
                        if (a != null) {
                            AppletPanel.changeFrameAppContext(this.frame, SunToolkit.targetToAppContext(a));
                            break;
                        }
                        AppletPanel.changeFrameAppContext(this.frame, AppContext.getAppContext());
                        break;
                    }
                }
            }
        }
        this.panel.addAppletListener(new AppletEventListener(this));
        this.showStatus(amh.getMessage("status.start"));
        this.initEventQueue();
    }

    public MenuItem addMenuItem(Menu m, String s) {
        MenuItem mItem = new MenuItem(amh.getMessage(s));
        mItem.addActionListener(new UserActionListener());
        return m.add(mItem);
    }

    private void initEventQueue() {
        String eventList = System.getProperty("appletviewer.send.event");
        if (eventList == null) {
            this.panel.sendEvent(1);
            this.panel.sendEvent(2);
            this.panel.sendEvent(3);
        } else {
            String[] events = this.splitSeparator(",", eventList);
            for (int i = 0; i < events.length; ++i) {
                System.out.println("Adding event to queue: " + events[i]);
                if (events[i].equals("dispose")) {
                    this.panel.sendEvent(0);
                    continue;
                }
                if (events[i].equals("load")) {
                    this.panel.sendEvent(1);
                    continue;
                }
                if (events[i].equals("init")) {
                    this.panel.sendEvent(2);
                    continue;
                }
                if (events[i].equals("start")) {
                    this.panel.sendEvent(3);
                    continue;
                }
                if (events[i].equals("stop")) {
                    this.panel.sendEvent(4);
                    continue;
                }
                if (events[i].equals("destroy")) {
                    this.panel.sendEvent(5);
                    continue;
                }
                if (events[i].equals("quit")) {
                    this.panel.sendEvent(6);
                    continue;
                }
                if (events[i].equals("error")) {
                    this.panel.sendEvent(7);
                    continue;
                }
                System.out.println("Unrecognized event name: " + events[i]);
            }
            while (!this.panel.emptyEventQueue()) {
            }
            this.appletSystemExit();
        }
    }

    private String[] splitSeparator(String sep, String s) {
        Vector<String> v = new Vector<String>();
        int tokenStart = 0;
        int tokenEnd = 0;
        while ((tokenEnd = s.indexOf(sep, tokenStart)) != -1) {
            v.addElement(s.substring(tokenStart, tokenEnd));
            tokenStart = tokenEnd + 1;
        }
        v.addElement(s.substring(tokenStart));
        Object[] retVal = new String[v.size()];
        v.copyInto(retVal);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioClip getAudioClip(URL url) {
        AppletViewer.checkConnect(url);
        Map map = audioClips;
        synchronized (map) {
            AudioClip clip = (AudioClip)audioClips.get(url);
            if (clip == null) {
                clip = new AppletAudioClip(url);
                audioClips.put(url, clip);
            }
            return clip;
        }
    }

    @Override
    public Image getImage(URL url) {
        return AppletViewer.getCachedImage(url);
    }

    static Image getCachedImage(URL url) {
        return (Image)AppletViewer.getCachedImageRef(url).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Ref getCachedImageRef(URL url) {
        Map map = imageRefs;
        synchronized (map) {
            AppletImageRef ref = (AppletImageRef)imageRefs.get(url);
            if (ref == null) {
                ref = new AppletImageRef(url);
                imageRefs.put(url, ref);
            }
            return ref;
        }
    }

    static void flushImageCache() {
        imageRefs.clear();
    }

    @Override
    public Applet getApplet(String name) {
        AppletSecurity security = (AppletSecurity)System.getSecurityManager();
        name = name.toLowerCase();
        SocketPermission panelSp = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Enumeration e = appletPanels.elements();
        while (e.hasMoreElements()) {
            SocketPermission sp;
            AppletPanel p = (AppletPanel)e.nextElement();
            String param = p.getParameter("name");
            if (param != null) {
                param = param.toLowerCase();
            }
            if (!name.equals(param) || !p.getDocumentBase().equals(this.panel.getDocumentBase()) || !panelSp.implies(sp = new SocketPermission(p.getCodeBase().getHost(), "connect"))) continue;
            return p.applet;
        }
        return null;
    }

    public Enumeration getApplets() {
        AppletSecurity security = (AppletSecurity)System.getSecurityManager();
        Vector<Applet> v = new Vector<Applet>();
        SocketPermission panelSp = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Enumeration e = appletPanels.elements();
        while (e.hasMoreElements()) {
            SocketPermission sp;
            AppletPanel p = (AppletPanel)e.nextElement();
            if (!p.getDocumentBase().equals(this.panel.getDocumentBase()) || !panelSp.implies(sp = new SocketPermission(p.getCodeBase().getHost(), "connect"))) continue;
            v.addElement(p.applet);
        }
        return v.elements();
    }

    @Override
    public void showDocument(URL url) {
    }

    @Override
    public void showDocument(URL url, String target) {
    }

    @Override
    public void showStatus(String status) {
        this.label.setText(status);
    }

    @Override
    public void setStream(String key, InputStream stream) throws IOException {
    }

    @Override
    public InputStream getStream(String key) {
        return null;
    }

    public Iterator getStreamKeys() {
        return null;
    }

    public static void printTag(PrintStream out, Hashtable atts) {
        String param;
        out.print("<applet");
        String v = (String)atts.get("codebase");
        if (v != null) {
            out.print(" codebase=\"" + v + "\"");
        }
        if ((v = (String)atts.get("code")) == null) {
            v = "applet.class";
        }
        out.print(" code=\"" + v + "\"");
        v = (String)atts.get("width");
        if (v == null) {
            v = "150";
        }
        out.print(" width=" + v);
        v = (String)atts.get("height");
        if (v == null) {
            v = "100";
        }
        out.print(" height=" + v);
        v = (String)atts.get("name");
        if (v != null) {
            out.print(" name=\"" + v + "\"");
        }
        out.println(">");
        int len = atts.size();
        String[] params = new String[len];
        len = 0;
        Enumeration e = atts.keys();
        while (e.hasMoreElements()) {
            int i;
            param = (String)e.nextElement();
            for (i = 0; i < len && params[i].compareTo(param) < 0; ++i) {
            }
            System.arraycopy(params, i, params, i + 1, len - i);
            params[i] = param;
            ++len;
        }
        for (int i = 0; i < len; ++i) {
            param = params[i];
            if (systemParam.get(param) != null) continue;
            out.println("<param name=" + param + " value=\"" + atts.get(param) + "\">");
        }
        out.println("</applet>");
    }

    public void updateAtts() {
        Dimension d = this.panel.size();
        Insets in = this.panel.insets();
        this.panel.atts.put("width", Integer.toString(d.width - (in.left + in.right)));
        this.panel.atts.put("height", Integer.toString(d.height - (in.top + in.bottom)));
    }

    void appletRestart() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    void appletReload() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(0);
        AppletPanel.flushClassLoader(this.panel.getClassLoaderCacheKey());
        try {
            this.panel.joinAppletThread();
            this.panel.release();
        }
        catch (InterruptedException e) {
            return;
        }
        this.panel.createAppletThread();
        this.panel.sendEvent(1);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    void appletSave() {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                AppletViewer.this.panel.sendEvent(4);
                FileDialog fd = new FileDialog((Frame)AppletViewer.this, amh.getMessage("appletsave.filedialogtitle"), 1);
                fd.setDirectory(System.getProperty("user.dir"));
                fd.setFile(defaultSaveFile);
                fd.show();
                String fname = fd.getFile();
                if (fname == null) {
                    AppletViewer.this.panel.sendEvent(3);
                    return null;
                }
                String dname = fd.getDirectory();
                File file = new File(dname, fname);
                try {
                    BufferedOutputStream s = new BufferedOutputStream(new FileOutputStream(file));
                    ObjectOutputStream os = new ObjectOutputStream(s);
                    AppletViewer.this.showStatus(amh.getMessage("appletsave.err1", AppletViewer.this.panel.applet.toString(), file.toString()));
                    os.writeObject(AppletViewer.this.panel.applet);
                }
                catch (IOException ex) {
                    System.err.println(amh.getMessage("appletsave.err2", ex));
                }
                finally {
                    AppletViewer.this.panel.sendEvent(3);
                }
                return null;
            }
        });
    }

    void appletClone() {
        Point p = this.location();
        this.updateAtts();
        this.factory.createAppletViewer(p.x + 30, p.y + 30, this.panel.documentURL, (Hashtable)this.panel.atts.clone());
    }

    void appletTag() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.updateAtts();
        AppletViewer.printTag(new PrintStream(out), this.panel.atts);
        this.showStatus(amh.getMessage("applettag"));
        Point p = this.location();
        new TextFrame(p.x + 30, p.y + 30, amh.getMessage("applettag.textframe"), out.toString());
    }

    void appletInfo() {
        String str = this.panel.applet.getAppletInfo();
        if (str == null) {
            str = amh.getMessage("appletinfo.applet");
        }
        str = str + "\n\n";
        String[][] atts = this.panel.applet.getParameterInfo();
        if (atts != null) {
            for (int i = 0; i < atts.length; ++i) {
                str = str + atts[i][0] + " -- " + atts[i][1] + " -- " + atts[i][2] + "\n";
            }
        } else {
            str = str + amh.getMessage("appletinfo.param");
        }
        Point p = this.location();
        new TextFrame(p.x + 30, p.y + 30, amh.getMessage("appletinfo.textframe"), str);
    }

    void appletCharacterEncoding() {
        this.showStatus(amh.getMessage("appletencoding", encoding));
    }

    void appletEdit() {
    }

    void appletPrint() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (pj != null) {
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            if (pj.printDialog(aset)) {
                pj.setPrintable(this);
                try {
                    pj.print(aset);
                    this.statusMsgStream.println(amh.getMessage("appletprint.finish"));
                }
                catch (PrinterException e) {
                    this.statusMsgStream.println(amh.getMessage("appletprint.fail"));
                }
            } else {
                this.statusMsgStream.println(amh.getMessage("appletprint.cancel"));
            }
        } else {
            this.statusMsgStream.println(amh.getMessage("appletprint.fail"));
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pf, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        this.panel.applet.printAll(graphics);
        return 0;
    }

    public static synchronized void networkProperties() {
        if (props == null) {
            props = new AppletProps();
        }
        props.addNotify();
        props.setVisible(true);
    }

    void appletStart() {
        this.panel.sendEvent(3);
    }

    void appletStop() {
        this.panel.sendEvent(4);
    }

    private void appletShutdown(AppletPanel p) {
        p.sendEvent(4);
        p.sendEvent(5);
        p.sendEvent(0);
        p.sendEvent(6);
    }

    void appletClose() {
        final AppletViewerPanel p = this.panel;
        new Thread(new Runnable(){

            @Override
            public void run() {
                AppletViewer.this.appletShutdown(p);
                appletPanels.removeElement(p);
                AppletViewer.this.dispose();
                if (AppletViewer.countApplets() == 0) {
                    AppletViewer.this.appletSystemExit();
                }
            }
        }).start();
    }

    private void appletSystemExit() {
        if (this.factory.isStandalone()) {
            System.exit(0);
        }
    }

    protected void appletQuit() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Enumeration e = appletPanels.elements();
                while (e.hasMoreElements()) {
                    AppletPanel p = (AppletPanel)e.nextElement();
                    AppletViewer.this.appletShutdown(p);
                }
                AppletViewer.this.appletSystemExit();
            }
        }).start();
    }

    public void processUserAction(ActionEvent evt) {
        String label = ((MenuItem)evt.getSource()).getLabel();
        if (amh.getMessage("menuitem.restart").equals(label)) {
            this.appletRestart();
            return;
        }
        if (amh.getMessage("menuitem.reload").equals(label)) {
            this.appletReload();
            return;
        }
        if (amh.getMessage("menuitem.clone").equals(label)) {
            this.appletClone();
            return;
        }
        if (amh.getMessage("menuitem.stop").equals(label)) {
            this.appletStop();
            return;
        }
        if (amh.getMessage("menuitem.save").equals(label)) {
            this.appletSave();
            return;
        }
        if (amh.getMessage("menuitem.start").equals(label)) {
            this.appletStart();
            return;
        }
        if (amh.getMessage("menuitem.tag").equals(label)) {
            this.appletTag();
            return;
        }
        if (amh.getMessage("menuitem.info").equals(label)) {
            this.appletInfo();
            return;
        }
        if (amh.getMessage("menuitem.encoding").equals(label)) {
            this.appletCharacterEncoding();
            return;
        }
        if (amh.getMessage("menuitem.edit").equals(label)) {
            this.appletEdit();
            return;
        }
        if (amh.getMessage("menuitem.print").equals(label)) {
            this.appletPrint();
            return;
        }
        if (amh.getMessage("menuitem.props").equals(label)) {
            AppletViewer.networkProperties();
            return;
        }
        if (amh.getMessage("menuitem.close").equals(label)) {
            this.appletClose();
            return;
        }
        if (this.factory.isStandalone() && amh.getMessage("menuitem.quit").equals(label)) {
            this.appletQuit();
            return;
        }
    }

    public static int countApplets() {
        return appletPanels.size();
    }

    public static void skipSpace(Reader in) throws IOException {
        while (c >= 0 && (c == 32 || c == 9 || c == 10 || c == 13)) {
            c = in.read();
        }
    }

    public static String scanIdentifier(Reader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
            buf.append((char)c);
            c = in.read();
        }
        return buf.toString();
    }

    public static Hashtable scanTag(Reader in) throws IOException {
        Hashtable<String, String> atts = new Hashtable<String, String>();
        AppletViewer.skipSpace(in);
        while (c >= 0 && c != 62) {
            String att = AppletViewer.scanIdentifier(in);
            String val = "";
            AppletViewer.skipSpace(in);
            if (c == 61) {
                int quote = -1;
                c = in.read();
                AppletViewer.skipSpace(in);
                if (c == 39 || c == 34) {
                    quote = c;
                    c = in.read();
                }
                StringBuffer buf = new StringBuffer();
                while (c > 0 && (quote < 0 && c != 32 && c != 9 && c != 10 && c != 13 && c != 62 || quote >= 0 && c != quote)) {
                    buf.append((char)c);
                    c = in.read();
                }
                if (c == quote) {
                    c = in.read();
                }
                AppletViewer.skipSpace(in);
                val = buf.toString();
            }
            if (!val.equals("")) {
                atts.put(att.toLowerCase(Locale.ENGLISH), val);
            }
            while (!(c == 62 || c < 0 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95)) {
                c = in.read();
            }
        }
        return atts;
    }

    private static Reader makeReader(InputStream is) {
        if (encoding != null) {
            try {
                return new BufferedReader(new InputStreamReader(is, encoding));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        InputStreamReader r = new InputStreamReader(is);
        encoding = r.getEncoding();
        return new BufferedReader(r);
    }

    public static void parse(URL url, String enc) throws IOException {
        encoding = enc;
        AppletViewer.parse(url, System.out, new StdAppletViewerFactory());
    }

    public static void parse(URL url) throws IOException {
        AppletViewer.parse(url, System.out, new StdAppletViewerFactory());
    }

    public static void parse(URL url, PrintStream statusMsgStream, AppletViewerFactory factory) throws IOException {
        boolean isAppletTag = false;
        boolean isObjectTag = false;
        boolean isEmbedTag = false;
        String requiresNameWarning = amh.getMessage("parse.warning.requiresname");
        String paramOutsideWarning = amh.getMessage("parse.warning.paramoutside");
        String appletRequiresCodeWarning = amh.getMessage("parse.warning.applet.requirescode");
        String appletRequiresHeightWarning = amh.getMessage("parse.warning.applet.requiresheight");
        String appletRequiresWidthWarning = amh.getMessage("parse.warning.applet.requireswidth");
        String objectRequiresCodeWarning = amh.getMessage("parse.warning.object.requirescode");
        String objectRequiresHeightWarning = amh.getMessage("parse.warning.object.requiresheight");
        String objectRequiresWidthWarning = amh.getMessage("parse.warning.object.requireswidth");
        String embedRequiresCodeWarning = amh.getMessage("parse.warning.embed.requirescode");
        String embedRequiresHeightWarning = amh.getMessage("parse.warning.embed.requiresheight");
        String embedRequiresWidthWarning = amh.getMessage("parse.warning.embed.requireswidth");
        String appNotLongerSupportedWarning = amh.getMessage("parse.warning.appnotLongersupported");
        URLConnection conn = url.openConnection();
        Reader in = AppletViewer.makeReader(conn.getInputStream());
        url = conn.getURL();
        int ydisp = 1;
        Hashtable atts = null;
        while ((c = in.read()) != -1) {
            String nm;
            if (c != 60) continue;
            c = in.read();
            if (c == 47) {
                c = in.read();
                nm = AppletViewer.scanIdentifier(in);
                if (!nm.equalsIgnoreCase("applet") && !nm.equalsIgnoreCase("object") && !nm.equalsIgnoreCase("embed")) continue;
                if (isObjectTag && atts.get("code") == null && atts.get("object") == null) {
                    statusMsgStream.println(objectRequiresCodeWarning);
                    atts = null;
                }
                if (atts != null) {
                    factory.createAppletViewer(x, y, url, atts);
                    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                    if ((x += 30) > d.width - 300 || (y += 30) > d.height - 300) {
                        x = 0;
                        y = 2 * ydisp * 30;
                        ++ydisp;
                    }
                }
                atts = null;
                isAppletTag = false;
                isObjectTag = false;
                isEmbedTag = false;
                continue;
            }
            nm = AppletViewer.scanIdentifier(in);
            if (nm.equalsIgnoreCase("param")) {
                Hashtable t = AppletViewer.scanTag(in);
                String att = (String)t.get("name");
                if (att == null) {
                    statusMsgStream.println(requiresNameWarning);
                    continue;
                }
                String val = (String)t.get("value");
                if (val == null) {
                    statusMsgStream.println(requiresNameWarning);
                    continue;
                }
                if (atts != null) {
                    atts.put(att.toLowerCase(), val);
                    continue;
                }
                statusMsgStream.println(paramOutsideWarning);
                continue;
            }
            if (nm.equalsIgnoreCase("applet")) {
                isAppletTag = true;
                atts = AppletViewer.scanTag(in);
                if (atts.get("code") == null && atts.get("object") == null) {
                    statusMsgStream.println(appletRequiresCodeWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("width") == null) {
                    statusMsgStream.println(appletRequiresWidthWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("height") != null) continue;
                statusMsgStream.println(appletRequiresHeightWarning);
                atts = null;
                continue;
            }
            if (nm.equalsIgnoreCase("object")) {
                isObjectTag = true;
                atts = AppletViewer.scanTag(in);
                if (atts.get("codebase") != null) {
                    atts.remove("codebase");
                }
                if (atts.get("width") == null) {
                    statusMsgStream.println(objectRequiresWidthWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("height") != null) continue;
                statusMsgStream.println(objectRequiresHeightWarning);
                atts = null;
                continue;
            }
            if (nm.equalsIgnoreCase("embed")) {
                isEmbedTag = true;
                atts = AppletViewer.scanTag(in);
                if (atts.get("code") == null && atts.get("object") == null) {
                    statusMsgStream.println(embedRequiresCodeWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("width") == null) {
                    statusMsgStream.println(embedRequiresWidthWarning);
                    atts = null;
                    continue;
                }
                if (atts.get("height") != null) continue;
                statusMsgStream.println(embedRequiresHeightWarning);
                atts = null;
                continue;
            }
            if (!nm.equalsIgnoreCase("app")) continue;
            statusMsgStream.println(appNotLongerSupportedWarning);
            Hashtable atts2 = AppletViewer.scanTag(in);
            nm = (String)atts2.get("class");
            if (nm != null) {
                atts2.remove("class");
                atts2.put("code", nm + ".class");
            }
            if ((nm = (String)atts2.get("src")) != null) {
                atts2.remove("src");
                atts2.put("codebase", nm);
            }
            if (atts2.get("width") == null) {
                atts2.put("width", "100");
            }
            if (atts2.get("height") == null) {
                atts2.put("height", "100");
            }
            AppletViewer.printTag(statusMsgStream, atts2);
            statusMsgStream.println();
        }
        in.close();
    }

    @Deprecated
    public static void main(String[] argv) {
        Main.main(argv);
    }

    private static void checkConnect(URL url) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                Permission perm = url.openConnection().getPermission();
                if (perm != null) {
                    security.checkPermission(perm);
                } else {
                    security.checkConnect(url.getHost(), url.getPort());
                }
            }
            catch (IOException ioe) {
                security.checkConnect(url.getHost(), url.getPort());
            }
        }
    }

    static {
        systemParam.put("codebase", "codebase");
        systemParam.put("code", "code");
        systemParam.put("alt", "alt");
        systemParam.put("width", "width");
        systemParam.put("height", "height");
        systemParam.put("align", "align");
        systemParam.put("vspace", "vspace");
        systemParam.put("hspace", "hspace");
        x = 0;
        y = 0;
        encoding = null;
        amh = new AppletMessageHandler("appletviewer");
    }

    private final class UserActionListener
    implements ActionListener {
        private UserActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppletViewer.this.processUserAction(evt);
        }
    }
}

