/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.UniqueIdentity;

public class CertificateSubjectUniqueIdentity
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.subjectID";
    public static final String NAME = "subjectID";
    public static final String ID = "id";
    private UniqueIdentity id;

    public CertificateSubjectUniqueIdentity(UniqueIdentity id) {
        this.id = id;
    }

    public CertificateSubjectUniqueIdentity(DerInputStream in) throws IOException {
        this.id = new UniqueIdentity(in);
    }

    public CertificateSubjectUniqueIdentity(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.id = new UniqueIdentity(val);
    }

    public CertificateSubjectUniqueIdentity(DerValue val) throws IOException {
        this.id = new UniqueIdentity(val);
    }

    @Override
    public String toString() {
        if (this.id == null) {
            return "";
        }
        return this.id.toString();
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.id.encode(tmp, DerValue.createTag((byte)-128, false, (byte)2));
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof UniqueIdentity)) {
            throw new IOException("Attribute must be of type UniqueIdentity.");
        }
        if (!name.equalsIgnoreCase(ID)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
        }
        this.id = (UniqueIdentity)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(ID)) {
            return this.id;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(ID)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
        }
        this.id = null;
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(ID);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

