/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.snapshot;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshot;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshotView;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

final class ProfilerSnapshotNPS
extends ProfilerSnapshot {
    private static final Logger LOGGER = Logger.getLogger(ProfilerSnapshotNPS.class.getName());
    private LoadedSnapshot loadedSnapshot;
    private TopComponent srw;

    ProfilerSnapshotNPS() {
    }

    ProfilerSnapshotNPS(File snapshot, DataSource master) {
        super(snapshot, master);
        FileObject fobj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)snapshot));
        this.loadedSnapshot = ResultsManager.getDefault().loadSnapshot(fobj);
    }

    @Override
    public LoadedSnapshot getLoadedSnapshot() {
        return this.loadedSnapshot;
    }

    @Override
    protected void remove() {
        super.remove();
        ResultsManager.getDefault().closeSnapshot(this.loadedSnapshot);
    }

    @Override
    protected Image resolveIcon() {
        try {
            int snapshotType = this.getLoadedSnapshot().getType();
            if (snapshotType == 1) {
                return ImageUtilities.mergeImages((Image)CPU_ICON, (Image)NODE_BADGE, (int)0, (int)0);
            }
            if (snapshotType == 8 || snapshotType == 4 || snapshotType == 16) {
                return ImageUtilities.mergeImages((Image)MEMORY_ICON, (Image)NODE_BADGE, (int)0, (int)0);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to determine profiler snapshot type", e);
            return null;
        }
    }

    @Override
    JComponent getUIComponent() {
        if (this.srw == null) {
            this.srw = SnapshotResultsWindow.get((LoadedSnapshot)this.loadedSnapshot, (int)-1, (boolean)false);
            try {
                JComponent cpuResPanel = (JComponent)this.srw.getComponent(0);
                cpuResPanel.setOpaque(false);
                JTabbedPane tabbedPane = (JTabbedPane)cpuResPanel.getComponent(0);
                JComponent infoPanel = (JComponent)tabbedPane.getComponentAt(tabbedPane.getTabCount() - 1);
                infoPanel.setBorder(BorderFactory.createEmptyBorder());
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            this.srw.setPreferredSize(new Dimension(1, 1));
        }
        return this.srw;
    }

    @Override
    void closeComponent() {
        if (this.srw != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Method method = ProfilerSnapshotNPS.this.srw.getClass().getDeclaredMethod("componentClosed", new Class[0]);
                        if (method != null) {
                            method.setAccessible(true);
                            method.invoke((Object)ProfilerSnapshotNPS.this.srw, new Object[0]);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", noSuchMethodException);
                    }
                    catch (SecurityException securityException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", securityException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        LOGGER.throwing(ProfilerSnapshotView.class.getName(), "removed", invocationTargetException);
                    }
                    ProfilerSnapshotNPS.this.srw = null;
                }
            });
        }
    }
}

