-- DBMail db access control
-- Call it under DBA user

-- sqlplus log
SPOOL "grant.log";

DROP USER dbmail CASCADE;
CREATE USER dbmail IDENTIFIED BY dbmail
DEFAULT TABLESPACE DBMAIL_TS_DATA
TEMPORARY TABLESPACE TEMP
ACCOUNT UNLOCK 
PROFILE porta_users;

GRANT CREATE PROCEDURE, CREATE SEQUENCE, CREATE SESSION, CREATE TABLE, CREATE TRIGGER, CREATE SYNONYM, CREATE VIEW TO dbmail;
ALTER USER dbmail QUOTA UNLIMITED ON DBMAIL_TS_DATA;
ALTER USER dbmail QUOTA UNLIMITED ON DBMAIL_TS_IDX;

CREATE OR REPLACE TRIGGER sys.db_user_nls_session_settings
AFTER logon ON DBMAIL.SCHEMA
BEGIN
    EXECUTE IMMEDIATE 'ALTER SESSION SET nls_date_format=''YYYY-MM-DD''';
    EXECUTE IMMEDIATE 'ALTER SESSION SET NLS_TIMESTAMP_FORMAT=''YYYY-MM-DD HH24:MI:SS''';
    EXECUTE IMMEDIATE 'ALTER SESSION SET NLS_TIMESTAMP_TZ_FORMAT=''YYYY-MM-DD HH24:MI:SS''';
    EXECUTE IMMEDIATE 'ALTER SESSION SET NLS_COMP=''LINGUISTIC''';
    EXECUTE IMMEDIATE 'ALTER SESSION SET NLS_SORT=''BINARY_CI''';
END;
/

EXIT
