'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var cov_161lflitbr = function () {
  var path = '/Users/gajuskuizinas/Documents/dev/gajus/table/src/calculateRowHeightIndex.js',
      hash = '3ea7effa044c58c1829012ae1f0f20e85671abbe',
      global = new Function('return this')(),
      gcv = '__coverage__',
      coverageData = {
    path: '/Users/gajuskuizinas/Documents/dev/gajus/table/src/calculateRowHeightIndex.js',
    statementMap: {
      '0': {
        start: {
          line: 12,
          column: 21
        },
        end: {
          line: 12,
          column: 35
        }
      },
      '1': {
        start: {
          line: 14,
          column: 23
        },
        end: {
          line: 14,
          column: 25
        }
      },
      '2': {
        start: {
          line: 16,
          column: 2
        },
        end: {
          line: 32,
          column: 5
        }
      },
      '3': {
        start: {
          line: 17,
          column: 28
        },
        end: {
          line: 17,
          column: 56
        }
      },
      '4': {
        start: {
          line: 19,
          column: 4
        },
        end: {
          line: 29,
          column: 7
        }
      },
      '5': {
        start: {
          line: 20,
          column: 6
        },
        end: {
          line: 22,
          column: 7
        }
      },
      '6': {
        start: {
          line: 21,
          column: 8
        },
        end: {
          line: 21,
          column: 65
        }
      },
      '7': {
        start: {
          line: 24,
          column: 6
        },
        end: {
          line: 26,
          column: 7
        }
      },
      '8': {
        start: {
          line: 25,
          column: 8
        },
        end: {
          line: 25,
          column: 69
        }
      },
      '9': {
        start: {
          line: 28,
          column: 6
        },
        end: {
          line: 28,
          column: 122
        }
      },
      '10': {
        start: {
          line: 31,
          column: 4
        },
        end: {
          line: 31,
          column: 46
        }
      },
      '11': {
        start: {
          line: 34,
          column: 2
        },
        end: {
          line: 34,
          column: 22
        }
      }
    },
    fnMap: {
      '0': {
        name: '(anonymous_0)',
        decl: {
          start: {
            line: 11,
            column: 15
          },
          end: {
            line: 11,
            column: 16
          }
        },
        loc: {
          start: {
            line: 11,
            column: 33
          },
          end: {
            line: 35,
            column: 1
          }
        }
      },
      '1': {
        name: '(anonymous_1)',
        decl: {
          start: {
            line: 16,
            column: 18
          },
          end: {
            line: 16,
            column: 19
          }
        },
        loc: {
          start: {
            line: 16,
            column: 29
          },
          end: {
            line: 32,
            column: 3
          }
        }
      },
      '2': {
        name: '(anonymous_2)',
        decl: {
          start: {
            line: 19,
            column: 21
          },
          end: {
            line: 19,
            column: 22
          }
        },
        loc: {
          start: {
            line: 19,
            column: 40
          },
          end: {
            line: 29,
            column: 5
          }
        }
      }
    },
    branchMap: {
      '0': {
        loc: {
          start: {
            line: 20,
            column: 6
          },
          end: {
            line: 22,
            column: 7
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 20,
            column: 6
          },
          end: {
            line: 22,
            column: 7
          }
        }, {
          start: {
            line: 20,
            column: 6
          },
          end: {
            line: 22,
            column: 7
          }
        }]
      },
      '1': {
        loc: {
          start: {
            line: 24,
            column: 6
          },
          end: {
            line: 26,
            column: 7
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 24,
            column: 6
          },
          end: {
            line: 26,
            column: 7
          }
        }, {
          start: {
            line: 24,
            column: 6
          },
          end: {
            line: 26,
            column: 7
          }
        }]
      }
    },
    s: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0,
      '8': 0,
      '9': 0,
      '10': 0,
      '11': 0
    },
    f: {
      '0': 0,
      '1': 0,
      '2': 0
    },
    b: {
      '0': [0, 0],
      '1': [0, 0]
    }
  },
      coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  coverageData.hash = hash;
  return coverage[path] = coverageData;
}();

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _calculateCellHeight = require('./calculateCellHeight');

var _calculateCellHeight2 = _interopRequireDefault(_calculateCellHeight);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Calculates the vertical row span index.
 *
 * @param {Array[]} rows
 * @param {Object} config
 * @returns {number[]}
 */
exports.default = (rows, config) => {
  ++cov_161lflitbr.f[0];

  const tableWidth = (++cov_161lflitbr.s[0], rows[0].length);

  const rowSpanIndex = (++cov_161lflitbr.s[1], []);

  ++cov_161lflitbr.s[2];
  _lodash2.default.forEach(rows, cells => {
    ++cov_161lflitbr.f[1];

    const cellHeightIndex = (++cov_161lflitbr.s[3], _lodash2.default.fill(Array(tableWidth), 1));

    ++cov_161lflitbr.s[4];
    _lodash2.default.forEach(cells, (value, index1) => {
      ++cov_161lflitbr.f[2];
      ++cov_161lflitbr.s[5];

      if (!_lodash2.default.isNumber(config.columns[index1].width)) {
        ++cov_161lflitbr.b[0][0];
        ++cov_161lflitbr.s[6];

        throw new Error('column[index].width must be a number.');
      } else {
        ++cov_161lflitbr.b[0][1];
      }

      ++cov_161lflitbr.s[7];
      if (!_lodash2.default.isBoolean(config.columns[index1].wrapWord)) {
        ++cov_161lflitbr.b[1][0];
        ++cov_161lflitbr.s[8];

        throw new Error('column[index].wrapWord must be a boolean.');
      } else {
        ++cov_161lflitbr.b[1][1];
      }

      ++cov_161lflitbr.s[9];
      cellHeightIndex[index1] = (0, _calculateCellHeight2.default)(value, config.columns[index1].width, config.columns[index1].wrapWord);
    });

    ++cov_161lflitbr.s[10];
    rowSpanIndex.push(_lodash2.default.max(cellHeightIndex));
  });

  ++cov_161lflitbr.s[11];
  return rowSpanIndex;
};

module.exports = exports['default'];