/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class DownloadMembersAction
extends AbstractRelationAction {
    public DownloadMembersAction() {
        this.putValue("ShortDescription", I18n.tr("Download all members of the selected relations", new Object[0]));
        this.putValue("Name", I18n.tr("Download members", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "downloadincomplete"));
        this.putValue("help", HelpUtil.ht("/Dialog/RelationList#DownloadMembers"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || this.relations.isEmpty() || !Main.isDisplayingMapView()) {
            return;
        }
        Main.worker.submit(new DownloadRelationTask(this.relations, Main.getLayerManager().getEditLayer()));
    }

    @Override
    public void setPrimitives(Collection<? extends OsmPrimitive> collection) {
        this.relations = SubclassFilteredCollection.filter(DownloadMembersAction.getRelations(collection), relation -> !relation.isNew());
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.relations.isEmpty() && !Main.isOffline(OnlineResource.OSM_API));
    }
}

