/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.tools.AlphanumComparator;

public class TestError
implements Comparable<TestError>,
DataSetListener {
    private boolean ignored;
    private Severity severity;
    private String message;
    private String description;
    private String descriptionEn;
    private Collection<? extends OsmPrimitive> primitives;
    private Collection<?> highlighted;
    private Test tester;
    private int code;
    private boolean selected;

    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, Collection<? extends OsmPrimitive> collection, Collection<?> collection2) {
        this.tester = test;
        this.severity = severity;
        this.message = string;
        this.description = string2;
        this.descriptionEn = string3;
        this.primitives = collection;
        this.highlighted = collection2;
        this.code = n;
    }

    public TestError(Test test, Severity severity, String string, int n, Collection<? extends OsmPrimitive> collection, Collection<?> collection2) {
        this(test, severity, string, null, null, n, collection, collection2);
    }

    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, Collection<? extends OsmPrimitive> collection) {
        this(test, severity, string, string2, string3, n, collection, collection);
    }

    public TestError(Test test, Severity severity, String string, int n, Collection<? extends OsmPrimitive> collection) {
        this(test, severity, string, null, null, n, collection, collection);
    }

    public TestError(Test test, Severity severity, String string, int n, OsmPrimitive osmPrimitive) {
        this(test, severity, string, null, null, n, Collections.singletonList(osmPrimitive), Collections.singletonList(osmPrimitive));
    }

    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, OsmPrimitive osmPrimitive) {
        this(test, severity, string, string2, string3, n, Collections.singletonList(osmPrimitive));
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Collection<? extends OsmPrimitive> getPrimitives() {
        return this.primitives;
    }

    public Collection<? extends OsmPrimitive> getSelectablePrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(this.primitives.size());
        for (OsmPrimitive osmPrimitive : this.primitives) {
            if (!osmPrimitive.isSelectable()) continue;
            arrayList.add(osmPrimitive);
        }
        return arrayList;
    }

    public void setPrimitives(List<? extends OsmPrimitive> list) {
        this.primitives = list;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getIgnoreState() {
        TreeSet<String> treeSet = new TreeSet<String>();
        StringBuilder stringBuilder = new StringBuilder(this.getIgnoreSubGroup());
        for (OsmPrimitive object : this.primitives) {
            if (object.isNew()) {
                return null;
            }
            String string = "u";
            if (object instanceof Way) {
                string = "w";
            } else if (object instanceof Relation) {
                string = "r";
            } else if (object instanceof Node) {
                string = "n";
            }
            treeSet.add(string + '_' + object.getId());
        }
        for (String string : treeSet) {
            stringBuilder.append(':').append(string);
        }
        return stringBuilder.toString();
    }

    public String getIgnoreSubGroup() {
        String string = this.getIgnoreGroup();
        if (this.descriptionEn != null) {
            string = string + '_' + this.descriptionEn;
        }
        return string;
    }

    public String getIgnoreGroup() {
        return Integer.toString(this.code);
    }

    public void setIgnored(boolean bl) {
        this.ignored = bl;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public Test getTester() {
        return this.tester;
    }

    public void setTester(Test test) {
        this.tester = test;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isFixable() {
        return this.tester != null && this.tester.isFixable(this);
    }

    public Command getFix() {
        if (this.tester == null || !this.tester.isFixable(this) || this.primitives.isEmpty()) {
            return null;
        }
        return this.tester.fixError(this);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void visitHighlighted(ValidatorVisitor validatorVisitor) {
        for (Object obj : this.highlighted) {
            if (obj instanceof OsmPrimitive) {
                validatorVisitor.visit((OsmPrimitive)obj);
                continue;
            }
            if (obj instanceof WaySegment) {
                validatorVisitor.visit((WaySegment)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            validatorVisitor.visit((List)obj);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Collection<?> getHighlighted() {
        return this.highlighted;
    }

    @Override
    public int compareTo(TestError testError) {
        if (this.equals(testError)) {
            return 0;
        }
        MultipleNameVisitor multipleNameVisitor = new MultipleNameVisitor();
        MultipleNameVisitor multipleNameVisitor2 = new MultipleNameVisitor();
        multipleNameVisitor.visit(this.getPrimitives());
        multipleNameVisitor2.visit(testError.getPrimitives());
        return AlphanumComparator.getInstance().compare(multipleNameVisitor.toString(), multipleNameVisitor2.toString());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        try {
            this.primitives.removeAll(primitivesRemovedEvent.getPrimitives());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (primitivesRemovedEvent.getPrimitives().containsAll(this.primitives)) {
                this.primitives = Collections.emptyList();
            }
            Main.warn((Throwable)unsupportedOperationException, "Unable to remove primitives from " + this + '.');
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
    }

    public String toString() {
        return "TestError [tester=" + this.tester + ", code=" + this.code + ", message=" + this.message + ']';
    }
}

