/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.printf;

import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.LiteralFormatNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.convert.ToDoubleWithCoercionNodeGen;
import org.jruby.truffle.core.format.convert.ToIntegerNodeGen;
import org.jruby.truffle.core.format.convert.ToStringNodeGen;
import org.jruby.truffle.core.format.format.FormatCharacterNodeGen;
import org.jruby.truffle.core.format.format.FormatFloatHumanReadableNodeGen;
import org.jruby.truffle.core.format.format.FormatFloatNodeGen;
import org.jruby.truffle.core.format.format.FormatIntegerBinaryNodeGen;
import org.jruby.truffle.core.format.format.FormatIntegerNodeGen;
import org.jruby.truffle.core.format.printf.SprintfConfig;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.format.read.array.ReadArgumentIndexValueNodeGen;
import org.jruby.truffle.core.format.read.array.ReadHashValueNodeGen;
import org.jruby.truffle.core.format.read.array.ReadIntegerNodeGen;
import org.jruby.truffle.core.format.read.array.ReadStringNodeGen;
import org.jruby.truffle.core.format.read.array.ReadValueNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBytesNodeGen;
import org.jruby.truffle.core.format.write.bytes.WritePaddedBytesNodeGen;
import org.jruby.truffle.core.rope.CodeRange;

public class PrintfSimpleTreeBuilder {
    private final RubyContext context;
    private final List<FormatNode> sequence = new ArrayList<FormatNode>();
    private final List<SprintfConfig> configs;
    public static int DEFAULT = -1;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public PrintfSimpleTreeBuilder(RubyContext context, List<SprintfConfig> configs) {
        this.context = context;
        this.configs = configs;
    }

    private void buildTree() {
        for (SprintfConfig config : this.configs) {
            FormatNode node;
            if (config.isLiteral()) {
                node = WriteBytesNodeGen.create(this.context, new LiteralFormatNode(this.context, config.getLiteralBytes()));
            } else {
                FormatNode valueNode;
                if (config.getNamesBytes() != null) {
                    DynamicObject key = this.context.getSymbolTable().getSymbol(this.context.getRopeTable().getRope(config.getNamesBytes(), (Encoding)USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT));
                    valueNode = ReadHashValueNodeGen.create(this.context, key, new SourceNode());
                } else {
                    valueNode = config.getAbsoluteArgumentIndex() != null ? ReadArgumentIndexValueNodeGen.create(this.context, config.getAbsoluteArgumentIndex(), new SourceNode()) : ReadValueNodeGen.create(this.context, new SourceNode());
                }
                FormatNode widthNode = config.isWidthStar() ? ReadIntegerNodeGen.create(this.context, new SourceNode()) : (config.isArgWidth() ? ReadArgumentIndexValueNodeGen.create(this.context, config.getWidth(), new SourceNode()) : new LiteralFormatNode(this.context, config.getWidth() == null ? -1 : config.getWidth()));
                FormatNode precisionNode = config.isPrecisionStar() ? ReadIntegerNodeGen.create(this.context, new SourceNode()) : (config.isPrecisionArg() ? ReadArgumentIndexValueNodeGen.create(this.context, config.getPrecision(), new SourceNode()) : new LiteralFormatNode(this.context, config.getPrecision() == null ? -1 : config.getPrecision()));
                block0 : switch (config.getFormatType()) {
                    case INTEGER: {
                        char format;
                        switch (config.getFormat()) {
                            case 'B': 
                            case 'b': {
                                format = config.getFormat();
                                break;
                            }
                            case 'd': 
                            case 'i': 
                            case 'u': {
                                format = 'd';
                                break;
                            }
                            case 'o': {
                                format = 'o';
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                format = config.getFormat();
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException();
                            }
                        }
                        if (config.getFormat() == 'b' || config.getFormat() == 'B') {
                            node = WriteBytesNodeGen.create(this.context, FormatIntegerBinaryNodeGen.create(this.context, format, config.isPlus(), config.isFsharp(), config.isMinus(), config.isHasSpace(), config.isZero(), widthNode, precisionNode, ToIntegerNodeGen.create(this.context, valueNode)));
                            break;
                        }
                        node = WriteBytesNodeGen.create(this.context, FormatIntegerNodeGen.create(this.context, format, config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), config.isFsharp(), widthNode, precisionNode, ToIntegerNodeGen.create(this.context, valueNode)));
                        break;
                    }
                    case FLOAT: {
                        switch (config.getFormat()) {
                            case 'E': 
                            case 'e': 
                            case 'f': {
                                node = WriteBytesNodeGen.create(this.context, FormatFloatNodeGen.create(this.context, config.getFormat(), config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), widthNode, precisionNode, ToDoubleWithCoercionNodeGen.create(this.context, valueNode)));
                                break block0;
                            }
                            case 'G': 
                            case 'g': {
                                node = WriteBytesNodeGen.create(this.context, FormatFloatHumanReadableNodeGen.create(this.context, ToDoubleWithCoercionNodeGen.create(this.context, valueNode)));
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    case OTHER: {
                        switch (config.getFormat()) {
                            case 'c': {
                                node = WriteBytesNodeGen.create(this.context, FormatCharacterNodeGen.create(this.context, config.isMinus(), widthNode, valueNode));
                                break block0;
                            }
                            case 'p': 
                            case 's': {
                                String conversionMethodName = config.getFormat() == 's' ? "to_s" : "inspect";
                                FormatNode conversionNode = config.getAbsoluteArgumentIndex() == null && config.getNamesBytes() == null ? ReadStringNodeGen.create(this.context, true, conversionMethodName, false, EMPTY_BYTES, new SourceNode()) : ToStringNodeGen.create(this.context, true, conversionMethodName, false, EMPTY_BYTES, valueNode);
                                if (config.getWidth() != null || config.isWidthStar()) {
                                    node = WritePaddedBytesNodeGen.create(this.context, config.isMinus(), widthNode, conversionNode);
                                    break block0;
                                }
                                node = WriteBytesNodeGen.create(this.context, conversionNode);
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported type: " + config.getFormatType().toString());
                    }
                }
            }
            this.sequence.add(node);
        }
    }

    public FormatNode getNode() {
        this.buildTree();
        return new SequenceNode(this.context, this.sequence.toArray(new FormatNode[this.sequence.size()]));
    }
}

