# is-absolute [![NPM version](https://img.shields.io/npm/v/is-absolute.svg?style=flat)](https://www.npmjs.com/package/is-absolute) [![NPM downloads](https://img.shields.io/npm/dm/is-absolute.svg?style=flat)](https://npmjs.org/package/is-absolute) [![Build Status](https://img.shields.io/travis/jonschlinkert/is-absolute.svg?style=flat)](https://travis-ci.org/jonschlinkert/is-absolute)

> Polyfill for node.js `path.isAbolute`. Returns true if a file path is absolute.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install is-absolute --save
```

Originally based on the `isAbsolute` utility method in [express](https://github.com/visionmedia/express).

## Usage

```js
var isAbsolute = require('is-absolute');

isAbsolute('a/b/c.js');
//=> 'false'
isAbsolute('/a/b/c.js');
//=> 'true'
```

**Explicitly test windows paths**

```js
isAbsolute.posix('/foo/bar');
isAbsolute.posix('/user/docs/Letter.txt');
//=> true

isAbsolute.posix('foo/bar');
//=> false
```

**Explicitly test windows paths**

```js
var isAbsolute = require('is-absolute');

isAbsolute.win32('c:\\');
isAbsolute.win32('//C://user\\docs\\Letter.txt');
isAbsolute.win32('\\\\unc\\share');
isAbsolute.win32('\\\\unc\\share\\foo');
isAbsolute.win32('\\\\unc\\share\\foo\\');
isAbsolute.win32('\\\\unc\\share\\foo\\bar');
isAbsolute.win32('\\\\unc\\share\\foo\\bar\\');
isAbsolute.win32('\\\\unc\\share\\foo\\bar\\baz');
//=> true

isAbsolute.win32('a:foo/a/b/c/d');
isAbsolute.win32(':\\');
isAbsolute.win32('foo\\bar\\baz');
isAbsolute.win32('foo\\bar\\baz\\');
//=> false
```

## Related projects

You might also be interested in these projects:

* [is-dotfile](https://www.npmjs.com/package/is-dotfile): Return true if a file path is (or has) a dotfile. Returns false if the… [more](https://www.npmjs.com/package/is-dotfile) | [homepage](https://github.com/jonschlinkert/is-dotfile)
* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern.… [more](https://www.npmjs.com/package/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob)
* [is-relative](https://www.npmjs.com/package/is-relative): Returns `true` if the path appears to be relative. | [homepage](https://github.com/jonschlinkert/is-relative)
* [is-unc-path](https://www.npmjs.com/package/is-unc-path): Returns true if a filepath is a windows UNC file path. | [homepage](https://github.com/jonschlinkert/is-unc-path)
* [is-valid-glob](https://www.npmjs.com/package/is-valid-glob): Return true if a value is a valid glob pattern or patterns. | [homepage](https://github.com/jonschlinkert/is-valid-glob)

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/is-absolute/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/is-absolute/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v, on April 02, 2016._