/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilders;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMapValueStorage;

public class CumulativeStubVersion {
    private static final int VERSION = 30 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);

    public static int getCumulativeVersion() {
        int version = VERSION;
        for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            BinaryFileStubBuilder builder;
            IFileElementType type2;
            Language l;
            ParserDefinition parserDefinition;
            if (fileType instanceof LanguageFileType && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l = ((LanguageFileType)fileType).getLanguage())) != null && (type2 = parserDefinition.getFileNodeType()) instanceof IStubFileElementType) {
                version += ((IStubFileElementType)type2).getStubVersion();
            }
            if ((builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) == null) continue;
            version += builder.getStubVersion();
        }
        return version;
    }
}

