/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;

public class WayData
extends PrimitiveData
implements IWay {
    private static final long serialVersionUID = 106944939313286415L;
    private List<Long> nodes = new ArrayList<Long>();

    public WayData() {
    }

    public WayData(WayData wayData) {
        super(wayData);
        this.nodes.addAll(wayData.getNodes());
    }

    public List<Long> getNodes() {
        return this.nodes;
    }

    @Override
    public int getNodesCount() {
        return this.nodes.size();
    }

    @Override
    public long getNodeId(int n) {
        return this.nodes.get(n);
    }

    @Override
    public boolean isClosed() {
        if (this.isIncomplete()) {
            return false;
        }
        return this.nodes.get(0).equals(this.nodes.get(this.nodes.size() - 1));
    }

    public void setNodes(List<Long> list) {
        this.nodes = new ArrayList<Long>(list);
    }

    @Override
    public WayData makeCopy() {
        return new WayData(this);
    }

    @Override
    public String toString() {
        return super.toString() + " WAY" + this.nodes;
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    @Override
    public void accept(PrimitiveVisitor primitiveVisitor) {
        primitiveVisitor.visit(this);
    }
}

