/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.gif;

import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.gif.GIFDescriptor;
import com.sun.javafx.iio.gif.GIFImageLoader;
import com.sun.javafx.iio.gif.GIFImageLoader2;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class GIFImageLoaderFactory
implements ImageLoaderFactory {
    private static final String selectorPropertyName = "prism.useOldGIF";
    private static boolean useOldGIF = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean(GIFImageLoaderFactory.selectorPropertyName);
        }
    });
    private static final GIFImageLoaderFactory theInstance = new GIFImageLoaderFactory();

    private GIFImageLoaderFactory() {
    }

    public static final ImageLoaderFactory getInstance() {
        return theInstance;
    }

    @Override
    public ImageFormatDescription getFormatDescription() {
        return GIFDescriptor.getInstance();
    }

    @Override
    public ImageLoader createImageLoader(InputStream inputStream) throws IOException {
        return useOldGIF ? new GIFImageLoader(inputStream) : new GIFImageLoader2(inputStream);
    }
}

