/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.paramtable;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.paramtable.addins.ParamAddinInterface;

public abstract class HttpPanelParamTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8714941615215038148L;
    private static final Logger log = Logger.getLogger(HttpPanelParamTableModel.class);
    private static final String[] columnNames = new String[]{Constant.messages.getString("http.panel.view.tableparam.type"), Constant.messages.getString("http.panel.view.table.paramName"), Constant.messages.getString("http.panel.view.table.paramValue"), Constant.messages.getString("http.panel.view.tableparam.functions")};
    protected HttpMessage httpMessage;
    protected LinkedList<HtmlParameter> allParams = new LinkedList();
    private boolean isEditable;
    private boolean hasChanged;

    @Override
    public int getColumnCount() {
        if (this.isEditable) {
            return 4;
        }
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.allParams.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n > this.allParams.size() || n < 0) {
            return null;
        }
        HtmlParameter htmlParameter = this.allParams.get(n);
        switch (n2) {
            case 0: {
                return htmlParameter.getType();
            }
            case 1: {
                return htmlParameter.getName();
            }
            case 2: {
                return htmlParameter.getValue();
            }
        }
        return "";
    }

    public Class<String> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        HtmlParameter htmlParameter = this.allParams.get(n);
        if (n2 == 0) {
            htmlParameter.setType((HtmlParameter.Type)((Object)object));
            bl = true;
        } else if (n2 == 1) {
            htmlParameter.setName((String)object);
            bl = true;
        } else if (n2 == 2) {
            htmlParameter.setValue((String)object);
            bl = true;
        } else if (n2 == 3 && object instanceof ParamAddinInterface) {
            try {
                htmlParameter.setValue(((ParamAddinInterface)object).convertData(htmlParameter.getValue()));
                bl = true;
                n2 = 2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.warn((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            }
        }
        if (bl) {
            this.hasChanged = true;
            this.fireTableCellUpdated(n, n2);
        }
        if (!(n != this.allParams.size() - 1 || (htmlParameter = this.allParams.getLast()).getName().isEmpty() && htmlParameter.getValue().isEmpty())) {
            this.allParams.add(this.getDefaultHtmlParameter());
            this.fireTableRowsInserted(n + 1, n + 1);
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.isEditable;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public void setHttpMessage(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.hasChanged = false;
        this.allParams.clear();
        if (this.httpMessage == null) {
            this.fireTableDataChanged();
            return;
        }
        this.loadAllParams();
        if (this.isEditable) {
            this.allParams.add(this.getDefaultHtmlParameter());
        }
        this.fireTableDataChanged();
    }

    public HttpMessage getHttpMessage() {
        return this.httpMessage;
    }

    public void save() {
        if (!this.hasChanged) {
            return;
        }
        this.saveAllParams();
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected abstract void loadAllParams();

    public abstract void saveAllParams();

    protected abstract HtmlParameter getDefaultHtmlParameter();
}

