/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.io;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.core.Database;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.util.FuzzerFileFilter;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class LoadFuzzers {
    public LoadFuzzers(JBroFuzzWindow mWindow) {
        JFileChooser fc;
        mWindow.setTabShow(125);
        Logger.log("Load Fuzzers from file", 1);
        FuzzerFileFilter filter = new FuzzerFileFilter();
        String dirString = JBroFuzz.PREFS.get(JBroFuzzPrefs.DIRS[3].getId(), System.getProperty("user.dir"));
        try {
            fc = new File(dirString).isDirectory() ? new JFileChooser(dirString) : new JFileChooser();
        }
        catch (SecurityException e1) {
            fc = new JFileChooser();
            Logger.log("A security exception occured, while attempting to point to a directory", 4);
        }
        fc.setFileFilter(filter);
        int returnVal = fc.showOpenDialog(mWindow);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            Logger.log("Opening: " + file.getName(), 1);
            String path = file.getAbsolutePath().toLowerCase();
            if (!path.endsWith(".jbrf")) {
                JOptionPane.showMessageDialog(fc, "The file selected is not a valid .jbrf file", " JBroFuzz - Open ", 2);
                return;
            }
            Database updateDB = new Database(path);
            mWindow.getJBroFuzz().setDatabase(updateDB);
            mWindow.getPanelPayloads().updateFuzzers();
            String parentDir = file.getParent();
            if (parentDir != null) {
                JBroFuzz.PREFS.put(JBroFuzzPrefs.DIRS[3].getId(), parentDir);
            }
        }
    }
}

