/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.ScriptService;

public final class Script
implements ToXContent,
Writeable {
    public static final String DEFAULT_SCRIPT_LANG = "painless";
    private String script;
    private ScriptService.ScriptType type;
    @Nullable
    private String lang;
    @Nullable
    private Map<String, Object> params;
    @Nullable
    private XContentType contentType;

    public Script(String script) {
        this(script, ScriptService.ScriptType.INLINE, null, null);
    }

    public Script(String script, ScriptService.ScriptType type, String lang, @Nullable Map<String, ?> params) {
        this(script, type, lang, params, null);
    }

    public Script(String script, ScriptService.ScriptType type, String lang, @Nullable Map<String, ?> params, @Nullable XContentType contentType) {
        if (contentType != null && type != ScriptService.ScriptType.INLINE) {
            throw new IllegalArgumentException("The parameter contentType only makes sense for inline scripts");
        }
        this.script = Objects.requireNonNull(script);
        this.type = Objects.requireNonNull(type);
        this.lang = lang == null ? DEFAULT_SCRIPT_LANG : lang;
        this.params = params;
        this.contentType = contentType;
    }

    public Script(StreamInput in) throws IOException {
        this.script = in.readString();
        if (in.readBoolean()) {
            this.type = ScriptService.ScriptType.readFrom(in);
        }
        this.lang = in.readOptionalString();
        this.params = in.readMap();
        if (in.readBoolean()) {
            this.contentType = XContentType.readFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.script);
        boolean hasType = this.type != null;
        out.writeBoolean(hasType);
        if (hasType) {
            ScriptService.ScriptType.writeTo(this.type, out);
        }
        out.writeOptionalString(this.lang);
        out.writeMap(this.params);
        boolean hasContentType = this.contentType != null;
        out.writeBoolean(hasContentType);
        if (hasContentType) {
            XContentType.writeTo(this.contentType, out);
        }
    }

    public String getScript() {
        return this.script;
    }

    public ScriptService.ScriptType getType() {
        return this.type;
    }

    public String getLang() {
        return this.lang;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public XContentType getContentType() {
        return this.contentType;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        if (this.type == null) {
            return builder.value(this.script);
        }
        builder.startObject();
        if (this.type == ScriptService.ScriptType.INLINE && this.contentType != null && builder.contentType() == this.contentType) {
            builder.rawField(this.type.getParseField().getPreferredName(), new BytesArray(this.script));
        } else {
            builder.field(this.type.getParseField().getPreferredName(), this.script);
        }
        if (this.lang != null) {
            builder.field(ScriptField.LANG.getPreferredName(), this.lang);
        }
        if (this.params != null) {
            builder.field(ScriptField.PARAMS.getPreferredName(), this.params);
        }
        builder.endObject();
        return builder;
    }

    public static Script parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return Script.parse(parser, parseFieldMatcher, null);
    }

    public static Script parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher, @Nullable String lang) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return new Script(parser.text(), ScriptService.ScriptType.INLINE, lang, null);
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("expected a string value or an object, but found [{}] instead", new Object[]{token});
        }
        String script = null;
        ScriptService.ScriptType type = null;
        Map<String, Object> params = null;
        XContentType contentType = null;
        String cfn = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                cfn = parser.currentName();
                continue;
            }
            if (parseFieldMatcher.match(cfn, ScriptService.ScriptType.INLINE.getParseField())) {
                type = ScriptService.ScriptType.INLINE;
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    contentType = parser.contentType();
                    XContentBuilder builder = XContentFactory.contentBuilder(contentType);
                    script = builder.copyCurrentStructure(parser).bytes().utf8ToString();
                    continue;
                }
                script = parser.text();
                continue;
            }
            if (parseFieldMatcher.match(cfn, ScriptService.ScriptType.FILE.getParseField())) {
                type = ScriptService.ScriptType.FILE;
                if (token == XContentParser.Token.VALUE_STRING) {
                    script = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{cfn, token});
            }
            if (parseFieldMatcher.match(cfn, ScriptService.ScriptType.STORED.getParseField())) {
                type = ScriptService.ScriptType.STORED;
                if (token == XContentParser.Token.VALUE_STRING) {
                    script = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{cfn, token});
            }
            if (parseFieldMatcher.match(cfn, ScriptField.LANG)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    lang = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{cfn, token});
            }
            if (parseFieldMatcher.match(cfn, ScriptField.PARAMS)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    params = parser.map();
                    continue;
                }
                throw new ElasticsearchParseException("expected an object for field [{}], but found [{}]", new Object[]{cfn, token});
            }
            throw new ElasticsearchParseException("unexpected field [{}]", cfn);
        }
        if (script == null) {
            throw new ElasticsearchParseException("expected one of [{}], [{}] or [{}] fields, but found none", ScriptService.ScriptType.INLINE.getParseField().getPreferredName(), ScriptService.ScriptType.FILE.getParseField().getPreferredName(), ScriptService.ScriptType.STORED.getParseField().getPreferredName());
        }
        return new Script(script, type, lang, params, contentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lang, this.params, this.script, this.type, this.contentType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        return Objects.equals(this.lang, other.lang) && Objects.equals(this.params, other.params) && Objects.equals(this.script, other.script) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.contentType, (Object)other.contentType);
    }

    public String toString() {
        return "[script: " + this.script + ", type: " + this.type.getParseField().getPreferredName() + ", lang: " + this.lang + ", params: " + this.params + "]";
    }

    public static interface ScriptField {
        public static final ParseField SCRIPT = new ParseField("script", new String[0]);
        public static final ParseField LANG = new ParseField("lang", new String[0]);
        public static final ParseField PARAMS = new ParseField("params", new String[0]);
    }
}

