/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class GroovyMBean
extends GroovyObjectSupport {
    private final MBeanServerConnection server;
    private final ObjectName name;
    private MBeanInfo beanInfo;
    private final boolean ignoreErrors;
    private final Map operations = new HashMap();

    public GroovyMBean(MBeanServerConnection server, String objectName) throws JMException, IOException {
        this(server, objectName, false);
    }

    public GroovyMBean(MBeanServerConnection server, String objectName, boolean ignoreErrors) throws JMException, IOException {
        this(server, new ObjectName(objectName), ignoreErrors);
    }

    public GroovyMBean(MBeanServerConnection server, ObjectName name) throws JMException, IOException {
        this(server, name, false);
    }

    public GroovyMBean(MBeanServerConnection server, ObjectName name, boolean ignoreErrors) throws JMException, IOException {
        this.server = server;
        this.name = name;
        this.ignoreErrors = ignoreErrors;
        this.beanInfo = server.getMBeanInfo(name);
        MBeanOperationInfo[] operationInfos = this.beanInfo.getOperations();
        for (int i = 0; i < operationInfos.length; ++i) {
            MBeanOperationInfo info = operationInfos[i];
            String[] signature = this.createSignature(info);
            String operationKey = this.createOperationKey(info.getName(), signature.length);
            this.operations.put(operationKey, signature);
        }
    }

    public MBeanServerConnection server() {
        return this.server;
    }

    public ObjectName name() {
        return this.name;
    }

    public MBeanInfo info() {
        return this.beanInfo;
    }

    public Object getProperty(String property) {
        block3: {
            try {
                return this.server.getAttribute(this.name, property);
            }
            catch (MBeanException e) {
                this.throwExceptionWithTarget("Could not access property: " + property + ". Reason: ", e);
            }
            catch (Exception e) {
                if (this.ignoreErrors) break block3;
                this.throwException("Could not access property: " + property + ". Reason: ", e);
            }
        }
        return null;
    }

    public void setProperty(String property, Object value) {
        try {
            this.server.setAttribute(this.name, new Attribute(property, value));
        }
        catch (MBeanException e) {
            this.throwExceptionWithTarget("Could not set property: " + property + ". Reason: ", e);
        }
        catch (Exception e) {
            this.throwException("Could not set property: " + property + ". Reason: ", e);
        }
    }

    public Object invokeMethod(String method, Object arguments) {
        Object[] argArray = null;
        argArray = arguments instanceof Object[] ? (Object[])arguments : new Object[]{arguments};
        String operationKey = this.createOperationKey(method, argArray.length);
        String[] signature = (String[])this.operations.get(operationKey);
        if (signature != null) {
            try {
                return this.server.invoke(this.name, method, argArray, signature);
            }
            catch (MBeanException e) {
                this.throwExceptionWithTarget("Could not invoke method: " + method + ". Reason: ", e);
            }
            catch (Exception e) {
                this.throwException("Could not invoke method: " + method + ". Reason: ", e);
            }
            return null;
        }
        return super.invokeMethod(method, arguments);
    }

    protected String[] createSignature(MBeanOperationInfo info) {
        MBeanParameterInfo[] params = info.getSignature();
        String[] answer = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            answer[i] = params[i].getType();
        }
        return answer;
    }

    protected String createOperationKey(String operation, int params) {
        return operation + "_" + params;
    }

    public Collection listAttributeNames() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanAttributeInfo[] attrs = this.beanInfo.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                MBeanAttributeInfo attr = attrs[i];
                list.add(attr.getName());
            }
        }
        catch (Exception e) {
            this.throwException("Could not list attribute names. Reason: ", e);
        }
        return list;
    }

    public List listAttributeValues() {
        ArrayList<String> list = new ArrayList<String>();
        Collection names = this.listAttributeNames();
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            try {
                Object val = this.getProperty(name);
                if (val == null) continue;
                list.add(name + " : " + val.toString());
            }
            catch (Exception e) {
                this.throwException("Could not list attribute values. Reason: ", e);
            }
        }
        return list;
    }

    public Collection listAttributeDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanAttributeInfo[] attrs = this.beanInfo.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                MBeanAttributeInfo attr = attrs[i];
                list.add(this.describeAttribute(attr));
            }
        }
        catch (Exception e) {
            this.throwException("Could not list attribute descriptions. Reason: ", e);
        }
        return list;
    }

    protected String describeAttribute(MBeanAttributeInfo attr) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (attr.isReadable()) {
            buf.append("r");
        }
        if (attr.isWritable()) {
            buf.append("w");
        }
        buf.append(") ").append(attr.getType()).append(" ").append(attr.getName());
        return buf.toString();
    }

    public String describeAttribute(String attributeName) {
        String ret = "Attribute not found";
        try {
            MBeanAttributeInfo[] attributes = this.beanInfo.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                MBeanAttributeInfo attribute = attributes[i];
                if (!attribute.getName().equals(attributeName)) continue;
                return this.describeAttribute(attribute);
            }
        }
        catch (Exception e) {
            this.throwException("Could not describe attribute '" + attributeName + "'. Reason: ", e);
        }
        return ret;
    }

    public Collection listOperationNames() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanOperationInfo[] operations = this.beanInfo.getOperations();
            for (int i = 0; i < operations.length; ++i) {
                MBeanOperationInfo operation = operations[i];
                list.add(operation.getName());
            }
        }
        catch (Exception e) {
            this.throwException("Could not list operation names. Reason: ", e);
        }
        return list;
    }

    public Collection listOperationDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanOperationInfo[] operations = this.beanInfo.getOperations();
            for (int i = 0; i < operations.length; ++i) {
                MBeanOperationInfo operation = operations[i];
                list.add(this.describeOperation(operation));
            }
        }
        catch (Exception e) {
            this.throwException("Could not list operation descriptions. Reason: ", e);
        }
        return list;
    }

    public List describeOperation(String operationName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanOperationInfo[] operations = this.beanInfo.getOperations();
            for (int i = 0; i < operations.length; ++i) {
                MBeanOperationInfo operation = operations[i];
                if (!operation.getName().equals(operationName)) continue;
                list.add(this.describeOperation(operation));
            }
        }
        catch (Exception e) {
            this.throwException("Could not describe operations matching name '" + operationName + "'. Reason: ", e);
        }
        return list;
    }

    protected String describeOperation(MBeanOperationInfo operation) {
        StringBuffer buf = new StringBuffer();
        buf.append(operation.getReturnType()).append(" ").append(operation.getName()).append("(");
        MBeanParameterInfo[] params = operation.getSignature();
        for (int j = 0; j < params.length; ++j) {
            MBeanParameterInfo param = params[j];
            if (j != 0) {
                buf.append(", ");
            }
            buf.append(param.getType()).append(" ").append(param.getName());
        }
        buf.append(")");
        return buf.toString();
    }

    public String toString() {
        Iterator iterator;
        StringBuffer buf = new StringBuffer();
        buf.append("MBean Name:").append("\n  ").append(this.name.getCanonicalName()).append("\n  ");
        if (!this.listAttributeDescriptions().isEmpty()) {
            buf.append("\nAttributes:");
            iterator = this.listAttributeDescriptions().iterator();
            while (iterator.hasNext()) {
                buf.append("\n  ").append((String)iterator.next());
            }
        }
        if (!this.listOperationDescriptions().isEmpty()) {
            buf.append("\nOperations:");
            iterator = this.listOperationDescriptions().iterator();
            while (iterator.hasNext()) {
                buf.append("\n  ").append((String)iterator.next());
            }
        }
        return buf.toString();
    }

    private void throwException(String m, Exception e) {
        if (!this.ignoreErrors) {
            throw new GroovyRuntimeException(m + e, e);
        }
    }

    private void throwExceptionWithTarget(String m, MBeanException e) {
        if (!this.ignoreErrors) {
            throw new GroovyRuntimeException(m + e, e.getTargetException());
        }
    }
}

