/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskUpToDateState;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.OutputFilesCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.reflect.Instantiator;

public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final TaskHistoryRepository taskHistoryRepository;
    private final OutputFilesCollectionSnapshotter outputFilesSnapshotter;
    private final FileCollectionSnapshotter inputFilesSnapshotter;
    private final FileCollectionSnapshotter discoveredInputsSnapshotter;
    private final Instantiator instantiator;
    private final FileCollectionFactory fileCollectionFactory;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;

    public DefaultTaskArtifactStateRepository(TaskHistoryRepository taskHistoryRepository, Instantiator instantiator, OutputFilesCollectionSnapshotter outputFilesSnapshotter, FileCollectionSnapshotter inputFilesSnapshotter, FileCollectionSnapshotter discoveredInputsSnapshotter, FileCollectionFactory fileCollectionFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        this.taskHistoryRepository = taskHistoryRepository;
        this.instantiator = instantiator;
        this.outputFilesSnapshotter = outputFilesSnapshotter;
        this.inputFilesSnapshotter = inputFilesSnapshotter;
        this.discoveredInputsSnapshotter = discoveredInputsSnapshotter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        return new TaskArtifactStateImpl(task, this.taskHistoryRepository.getHistory(task));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskArtifactStateImpl
    implements TaskArtifactState,
    TaskExecutionHistory {
        private final TaskInternal task;
        private final TaskHistoryRepository.History history;
        private boolean upToDate;
        private TaskUpToDateState states;
        private IncrementalTaskInputsInternal taskInputs;

        public TaskArtifactStateImpl(TaskInternal task, TaskHistoryRepository.History history) {
            this.task = task;
            this.history = history;
        }

        @Override
        public boolean isUpToDate(Collection<String> messages) {
            if (this.collectChangedMessages(messages, this.getStates().getAllTaskChanges())) {
                this.upToDate = true;
                return true;
            }
            return false;
        }

        private boolean collectChangedMessages(Collection<String> messages, TaskStateChanges stateChanges) {
            boolean up2date = true;
            for (TaskStateChange stateChange : stateChanges) {
                if (messages != null) {
                    messages.add(stateChange.getMessage());
                    up2date = false;
                    continue;
                }
                return false;
            }
            return up2date;
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            assert (!this.upToDate) : "Should not be here if the task is up-to-date";
            this.taskInputs = this.canPerformIncrementalBuild() ? (IncrementalTaskInputsInternal)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, new Object[]{this.getStates().getInputFilesChanges()}) : (IncrementalTaskInputsInternal)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task});
            return this.taskInputs;
        }

        private boolean canPerformIncrementalBuild() {
            return this.collectChangedMessages(null, this.getStates().getRebuildChanges());
        }

        @Override
        public TaskCacheKey calculateCacheKey() {
            this.getStates();
            return this.history.getCurrentExecution().calculateCacheKey();
        }

        @Override
        public FileCollection getOutputFiles() {
            TaskExecution lastExecution = this.history.getPreviousExecution();
            if (lastExecution != null && lastExecution.getOutputFilesSnapshot() != null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (FileCollectionSnapshot snapshot : lastExecution.getOutputFilesSnapshot().values()) {
                    builder.addAll(snapshot.getFiles());
                }
                return DefaultTaskArtifactStateRepository.this.fileCollectionFactory.fixed("Task " + this.task.getPath() + " outputs", (Collection<File>)builder.build());
            }
            return DefaultTaskArtifactStateRepository.this.fileCollectionFactory.empty("Task " + this.task.getPath() + " outputs");
        }

        @Override
        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        @Override
        public void beforeTask() {
        }

        @Override
        public void afterTask() {
            if (this.upToDate) {
                return;
            }
            if (this.taskInputs != null) {
                this.getStates().newInputs(this.taskInputs.getDiscoveredInputs());
            }
            this.getStates().getAllTaskChanges().snapshotAfterTask();
            this.history.update();
        }

        @Override
        public void finished() {
        }

        private TaskUpToDateState getStates() {
            if (this.states == null) {
                this.states = new TaskUpToDateState(this.task, this.history, DefaultTaskArtifactStateRepository.this.outputFilesSnapshotter, DefaultTaskArtifactStateRepository.this.inputFilesSnapshotter, DefaultTaskArtifactStateRepository.this.discoveredInputsSnapshotter, DefaultTaskArtifactStateRepository.this.fileCollectionFactory, DefaultTaskArtifactStateRepository.this.classLoaderHierarchyHasher);
            }
            return this.states;
        }
    }
}

