/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.dateOrRevision;

import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.util.text.StringUtil;
import org.netbeans.lib.cvsclient.command.Command;

public class SimpleRevision
implements RevisionOrDate {
    private final String myRevision;

    public SimpleRevision(String revision) {
        this.myRevision = SimpleRevision.prepareRevision(revision);
    }

    private static String prepareRevision(String revision) {
        if (revision == null) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)revision, (char)'-')) {
            return revision.substring(1);
        }
        return revision;
    }

    public String getRevision() {
        return this.myRevision;
    }

    public void setForCommand(Command command) {
        command.setUpdateByRevisionOrDate(this.myRevision, null);
    }

    public CvsRevisionNumber getCvsRevisionNumber() {
        if (this.myRevision == null) {
            return null;
        }
        try {
            return new CvsRevisionNumber(this.myRevision);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public String toString() {
        return this.myRevision;
    }
}

