/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.rt.execution.junit.ComparisonDetailsExtractor;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.ExceptionPacketFactory;
import com.intellij.rt.execution.junit.KnownException;
import com.intellij.rt.execution.junit.PacketFactory;
import com.intellij.rt.execution.junit.TestMeter;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.Packet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestResultsSender
extends RunListener {
    private static final String JUNIT_FRAMEWORK_COMPARISON_NAME = (class$junit$framework$ComparisonFailure == null ? (class$junit$framework$ComparisonFailure = JUnit4TestResultsSender.class$("junit.framework.ComparisonFailure")) : class$junit$framework$ComparisonFailure).getName();
    private static final String ORG_JUNIT_COMPARISON_NAME = "org.junit.ComparisonFailure";
    private final OutputObjectRegistry myRegistry;
    private Map myCurrentTestMeters = new HashMap();
    private Set myCurrentTests = new HashSet();
    static /* synthetic */ Class class$junit$framework$ComparisonFailure;
    static /* synthetic */ Class class$org$junit$Ignore;

    public JUnit4TestResultsSender(OutputObjectRegistry packetFactory) {
        this.myRegistry = packetFactory;
    }

    public synchronized void testFailure(Failure failure) throws Exception {
        Description description = failure.getDescription();
        Throwable throwable = failure.getException();
        Throwable cause = throwable.getCause();
        if (ComparisonFailureData.isAssertionError(throwable.getClass()) || ComparisonFailureData.isAssertionError(cause != null ? cause.getClass() : null)) {
            this.doAddFailure(description, throwable);
        } else {
            this.prepareDefectPacket(description, throwable).send();
        }
    }

    public void testAssumptionFailure(Failure failure) {
        Description description = failure.getDescription();
        this.prepareIgnoredPacket(description, null).addThrowable(failure.getException()).send();
    }

    public synchronized void testIgnored(Description description) throws Exception {
        String val = null;
        try {
            Ignore ignoredAnnotation = (Ignore)description.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestResultsSender.class$("org.junit.Ignore")) : class$org$junit$Ignore);
            if (ignoredAnnotation != null) {
                val = ignoredAnnotation.value();
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.testStarted(description);
        this.stopMeter(description);
        this.prepareIgnoredPacket(description, val).addLimitedString("").addLimitedString("").send();
        this.myRegistry.forget((Object)description);
    }

    private void doAddFailure(Description test, Throwable assertion) {
        JUnit4TestResultsSender.createExceptionNotification(assertion).createPacket(this.myRegistry, (Object)test).send();
    }

    private static boolean isComparisonFailure(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return JUnit4TestResultsSender.isComparisonFailure(throwable.getClass());
    }

    private static boolean isComparisonFailure(Class aClass) {
        if (aClass == null) {
            return false;
        }
        String throwableClassName = aClass.getName();
        if (throwableClassName.equals(JUNIT_FRAMEWORK_COMPARISON_NAME) || throwableClassName.equals(ORG_JUNIT_COMPARISON_NAME)) {
            return true;
        }
        return JUnit4TestResultsSender.isComparisonFailure(aClass.getSuperclass());
    }

    private static PacketFactory createExceptionNotification(Throwable assertion) {
        if (assertion instanceof KnownException) {
            return ((KnownException)assertion).getPacketFactory();
        }
        ComparisonFailureData notification = ExpectedPatterns.createExceptionNotification(assertion);
        if (notification != null) {
            return ComparisonDetailsExtractor.create((Throwable)assertion, (String)notification.getExpected(), (String)notification.getActual());
        }
        return new ExceptionPacketFactory(6, assertion);
    }

    private Packet prepareDefectPacket(Description test, Throwable assertion) {
        return this.myRegistry.createPacket().setTestState((Object)test, 8).addThrowable(assertion);
    }

    private Packet prepareIgnoredPacket(Description test, String val) {
        return this.myRegistry.createPacket().setTestState((Object)test, 5).addObject((Object)test).addLimitedString(val != null ? val : "");
    }

    public void testFinished(Description description) throws Exception {
        Object testMeter = this.myCurrentTestMeters.get(description);
        this.stopMeter(description);
        Packet packet = this.myRegistry.createPacket().setTestState((Object)description, 1);
        ((TestMeter)testMeter).writeTo(packet);
        packet.send();
        this.myRegistry.forget((Object)description);
    }

    private void stopMeter(Description test) {
        Object stopMeter;
        if (!this.myCurrentTests.remove(test)) {
            this.myCurrentTestMeters.put(test, new TestMeter());
            System.err.println("Wrong test finished. Last started: " + this.myCurrentTests + " stopped: " + test + "; " + test.getClass());
        }
        if ((stopMeter = this.myCurrentTestMeters.remove(test)) instanceof TestMeter) {
            ((TestMeter)stopMeter).stop();
        }
    }

    private void switchOutput(Packet switchPacket) {
        switchPacket.send();
    }

    public synchronized void testStarted(Description description) throws Exception {
        this.myCurrentTests.add(description);
        this.myRegistry.createPacket().setTestState((Object)description, 3).send();
        this.switchOutput(this.myRegistry.createPacket().switchInputTo((Object)description));
        this.myCurrentTestMeters.put(description, new TestMeter());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

