/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffContentFactory {
    @NotNull
    public static DiffContentFactory getInstance() {
        DiffContentFactory diffContentFactory = ServiceManager.getService(DiffContentFactory.class);
        if (diffContentFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactory", "getInstance"));
        }
        return diffContentFactory;
    }

    @NotNull
    public abstract EmptyContent createEmpty();

    @NotNull
    public abstract DocumentContent create(@NotNull String var1);

    @NotNull
    public abstract DocumentContent create(@NotNull String var1, @Nullable FileType var2);

    @NotNull
    public abstract DocumentContent create(@NotNull String var1, @Nullable FileType var2, boolean var3);

    @NotNull
    public abstract DocumentContent create(@NotNull String var1, @Nullable VirtualFile var2);

    @NotNull
    public abstract DocumentContent create(@NotNull String var1, @Nullable DocumentContent var2);

    @NotNull
    public abstract DocumentContent create(@Nullable Project var1, @NotNull Document var2);

    @NotNull
    public abstract DocumentContent create(@Nullable Project var1, @NotNull Document var2, @Nullable FileType var3);

    @NotNull
    public abstract DocumentContent create(@Nullable Project var1, @NotNull Document var2, @Nullable VirtualFile var3);

    @NotNull
    public abstract DocumentContent create(@NotNull Document var1, @Nullable DocumentContent var2);

    @NotNull
    public abstract DiffContent create(@Nullable Project var1, @NotNull VirtualFile var2);

    @Nullable
    public abstract DocumentContent createDocument(@Nullable Project var1, @NotNull VirtualFile var2);

    @Nullable
    public abstract FileContent createFile(@Nullable Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract DiffContent createClipboardContent();

    @NotNull
    public abstract DocumentContent createClipboardContent(@Nullable DocumentContent var1);

    @NotNull
    public abstract DiffContent createFromBytes(@Nullable Project var1, @NotNull VirtualFile var2, @NotNull byte[] var3) throws IOException;

    @NotNull
    public abstract DiffContent createBinary(@Nullable Project var1, @NotNull String var2, @NotNull FileType var3, @NotNull byte[] var4) throws IOException;
}

