/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRunConfigurationModule
extends RunConfigurationModule {
    private final boolean myClassesInLibraries;

    public JavaRunConfigurationModule(@NotNull Project project, boolean classesInLibs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/configurations/JavaRunConfigurationModule", "<init>"));
        }
        super(project);
        this.myClassesInLibraries = classesInLibs;
    }

    @Nullable
    public PsiClass findClass(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        return JavaExecutionUtil.findMainClass(this.getProject(), qualifiedName, this.getSearchScope());
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        Module module = this.getModule();
        if (module != null) {
            GlobalSearchScope globalSearchScope = this.myClassesInLibraries ? module.getModuleRuntimeScope(true) : GlobalSearchScope.moduleWithDependenciesScope(module);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaRunConfigurationModule", "getSearchScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.myClassesInLibraries ? GlobalSearchScope.allScope(this.getProject()) : GlobalSearchScope.projectScope(this.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaRunConfigurationModule", "getSearchScope"));
        }
        return globalSearchScope;
    }

    public static Collection<Module> getModulesForClass(@NotNull Project project, String className) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/configurations/JavaRunConfigurationModule", "getModulesForClass"));
        }
        if (project.isDefault()) {
            return Arrays.asList(ModuleManager.getInstance(project).getModules());
        }
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        PsiClass[] possibleClasses = JavaPsiFacade.getInstance(project).findClasses(className, GlobalSearchScope.projectScope(project));
        THashSet modules = new THashSet();
        for (PsiClass aClass : possibleClasses) {
            Module module = ModuleUtilCore.findModuleForPsiElement(aClass);
            if (module == null) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return Arrays.asList(ModuleManager.getInstance(project).getModules());
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : modules) {
            ModuleUtilCore.collectModulesDependsOn(module, result);
        }
        return result;
    }

    public PsiClass findNotNullClass(String className) throws RuntimeConfigurationWarning {
        PsiClass psiClass = this.findClass(className);
        if (psiClass == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message("class.not.found.in.module.error.message", className, this.getModuleName()));
        }
        return psiClass;
    }

    public PsiClass checkModuleAndClassName(String className, String expectedClassMessage) throws RuntimeConfigurationException {
        this.checkForWarning();
        return this.checkClassName(className, expectedClassMessage);
    }

    public PsiClass checkClassName(String className, String errorMessage) throws RuntimeConfigurationException {
        if (className == null || className.length() == 0) {
            throw new RuntimeConfigurationError(errorMessage);
        }
        return this.findNotNullClass(className);
    }
}

