/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ColoredOutputTypeRegistry {
    private final Map<String, Key> myRegisteredKeys = new HashMap<String, Key>();
    private static final TextAttributesKey[] myAnsiColorKeys = new TextAttributesKey[]{ConsoleHighlighter.BLACK, ConsoleHighlighter.RED, ConsoleHighlighter.GREEN, ConsoleHighlighter.YELLOW, ConsoleHighlighter.BLUE, ConsoleHighlighter.MAGENTA, ConsoleHighlighter.CYAN, ConsoleHighlighter.GRAY, ConsoleHighlighter.DARKGRAY, ConsoleHighlighter.RED_BRIGHT, ConsoleHighlighter.GREEN_BRIGHT, ConsoleHighlighter.YELLOW_BRIGHT, ConsoleHighlighter.BLUE_BRIGHT, ConsoleHighlighter.MAGENTA_BRIGHT, ConsoleHighlighter.CYAN_BRIGHT, ConsoleHighlighter.WHITE};

    public static ColoredOutputTypeRegistry getInstance() {
        return ServiceManager.getService(ColoredOutputTypeRegistry.class);
    }

    @NotNull
    public Key getOutputKey(@NonNls String attribute) {
        Key key = this.myRegisteredKeys.get(attribute);
        if (key != null) {
            Key key2 = key;
            if (key2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ColoredOutputTypeRegistry", "getOutputKey"));
            }
            return key2;
        }
        String completeAttribute = attribute;
        attribute = attribute.startsWith("\u001b[") ? attribute.substring(2) : StringUtil.trimStart((String)attribute, (String)"[");
        if ((attribute = StringUtil.trimEnd((String)attribute, (String)"m")).equals("0")) {
            Key key3 = ProcessOutputTypes.STDOUT;
            if (key3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ColoredOutputTypeRegistry", "getOutputKey"));
            }
            return key3;
        }
        AnsiTextAttributes attrs = new AnsiTextAttributes(attribute);
        Key newKey = new Key(completeAttribute);
        ConsoleViewContentType contentType = new ConsoleViewContentType(completeAttribute, attrs);
        ConsoleViewContentType.registerNewConsoleViewType(newKey, contentType);
        this.myRegisteredKeys.put(completeAttribute, newKey);
        Key key4 = newKey;
        if (key4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ColoredOutputTypeRegistry", "getOutputKey"));
        }
        return key4;
    }

    private static Color getAnsiColor(int value) {
        return ColoredOutputTypeRegistry.getColorByKey(ColoredOutputTypeRegistry.getAnsiColorKey(value));
    }

    private static Color getColorByKey(TextAttributesKey colorKey) {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(colorKey).getForegroundColor();
    }

    @NotNull
    private static Color getDefaultForegroundColor() {
        Color color;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attr = scheme.getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY);
        Color color2 = color = attr != null ? attr.getForegroundColor() : null;
        if (color == null) {
            color = scheme.getDefaultForeground();
        }
        Color color3 = color;
        if (color3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ColoredOutputTypeRegistry", "getDefaultForegroundColor"));
        }
        return color3;
    }

    @NotNull
    private static Color getDefaultBackgroundColor() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = scheme.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
        if (color == null) {
            color = scheme.getDefaultBackground();
        }
        Color color2 = color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ColoredOutputTypeRegistry", "getDefaultBackgroundColor"));
        }
        return color2;
    }

    public static TextAttributesKey getAnsiColorKey(int value) {
        if (value >= 16) {
            return ConsoleViewContentType.NORMAL_OUTPUT_KEY;
        }
        return myAnsiColorKeys[value];
    }

    private static class AnsiTextAttributes
    extends TextAttributes {
        int myForegroundColor = -1;
        int myBackgroundColor = -1;
        boolean myInverse = false;

        public AnsiTextAttributes(String attribute) {
            String[] strings;
            this.setEffectType(null);
            for (String string : strings = attribute.split(";")) {
                int value;
                try {
                    value = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (value == 1) {
                    this.setFontType(1);
                    continue;
                }
                if (value == 4) {
                    this.setEffectType(EffectType.LINE_UNDERSCORE);
                    continue;
                }
                if (value == 7) {
                    this.myInverse = true;
                    continue;
                }
                if (value == 22) {
                    this.setFontType(0);
                    continue;
                }
                if (value == 24) {
                    this.setEffectType(null);
                    continue;
                }
                if (value >= 30 && value <= 37) {
                    this.myForegroundColor = value - 30;
                    continue;
                }
                if (value == 38) continue;
                if (value == 39) {
                    this.myForegroundColor = -1;
                    continue;
                }
                if (value >= 40 && value <= 47) {
                    this.myBackgroundColor = value - 40;
                    continue;
                }
                if (value == 48) continue;
                if (value == 49) {
                    this.myBackgroundColor = -1;
                    continue;
                }
                if (value >= 90 && value <= 97) {
                    this.myForegroundColor = value - 82;
                    continue;
                }
                if (value < 100 || value > 107) continue;
                this.myBackgroundColor = value - 92;
            }
        }

        @Override
        public Color getForegroundColor() {
            if (this.myInverse) {
                return this.myBackgroundColor < 0 ? ColoredOutputTypeRegistry.getDefaultBackgroundColor() : ColoredOutputTypeRegistry.getAnsiColor(this.myBackgroundColor);
            }
            return this.myForegroundColor < 0 ? ColoredOutputTypeRegistry.getDefaultForegroundColor() : ColoredOutputTypeRegistry.getAnsiColor(this.myForegroundColor);
        }

        @Override
        public Color getBackgroundColor() {
            if (this.myInverse) {
                return this.myForegroundColor < 0 ? ColoredOutputTypeRegistry.getDefaultForegroundColor() : ColoredOutputTypeRegistry.getAnsiColor(this.myForegroundColor);
            }
            return this.myBackgroundColor < 0 ? ColoredOutputTypeRegistry.getDefaultBackgroundColor() : ColoredOutputTypeRegistry.getAnsiColor(this.myBackgroundColor);
        }

        @Override
        public Color getEffectColor() {
            return this.getEffectType() != null ? this.getForegroundColor() : null;
        }
    }
}

