/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionEnvironmentBuilder {
    @NotNull
    private RunProfile myRunProfile;
    @NotNull
    private ExecutionTarget myTarget;
    @NotNull
    private final Project myProject;
    @Nullable
    private RunnerSettings myRunnerSettings;
    @Nullable
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    @Nullable
    private RunContentDescriptor myContentToReuse;
    @Nullable
    private RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    @Nullable
    private String myRunnerId;
    private ProgramRunner<?> myRunner;
    private boolean myAssignNewId;
    @NotNull
    private Executor myExecutor;
    @Nullable
    private DataContext myDataContext;
    private final UserDataHolderBase myUserData;

    public ExecutionEnvironmentBuilder(@NotNull Project project, @NotNull Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "<init>"));
        }
        this.myTarget = DefaultExecutionTarget.INSTANCE;
        this.myUserData = new UserDataHolderBase();
        this.myProject = project;
        this.myExecutor = executor;
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull(project, executor, runProfile);
        if (builder == null) {
            throw new ExecutionException("Cannot find runner for " + runProfile.getName());
        }
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder;
        if (executionEnvironmentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        return executionEnvironmentBuilder;
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createOrNull(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "createOrNull"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "createOrNull"));
        }
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "createOrNull"));
        }
        ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), runProfile);
        if (runner == null) {
            return null;
        }
        return new ExecutionEnvironmentBuilder(project, executor).runner(runner).runProfile(runProfile);
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "createOrNull"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "createOrNull"));
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull(settings.getConfiguration().getProject(), executor, settings.getConfiguration());
        return builder == null ? null : builder.runnerAndSettings(builder.myRunner, settings);
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create(settings.getConfiguration().getProject(), executor, settings.getConfiguration());
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder.runnerAndSettings(builder.myRunner, settings);
        if (executionEnvironmentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        return executionEnvironmentBuilder;
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = new ExecutionEnvironmentBuilder(configuration.getProject(), executor).runProfile(configuration);
        if (executionEnvironmentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "create"));
        }
        return executionEnvironmentBuilder;
    }

    @NotNull
    Executor getExecutor() {
        Executor executor = this.myExecutor;
        if (executor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "getExecutor"));
        }
        return executor;
    }

    public ExecutionEnvironmentBuilder(@NotNull ExecutionEnvironment copySource) {
        if (copySource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copySource", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "<init>"));
        }
        this.myTarget = DefaultExecutionTarget.INSTANCE;
        this.myUserData = new UserDataHolderBase();
        this.myTarget = copySource.getExecutionTarget();
        this.myProject = copySource.getProject();
        this.myRunnerAndConfigurationSettings = copySource.getRunnerAndConfigurationSettings();
        this.myRunProfile = copySource.getRunProfile();
        this.myRunnerSettings = copySource.getRunnerSettings();
        this.myConfigurationSettings = copySource.getConfigurationSettings();
        this.myRunner = copySource.getRunner();
        this.myContentToReuse = copySource.getContentToReuse();
        this.myExecutor = copySource.getExecutor();
        copySource.copyUserDataTo(this.myUserData);
    }

    public ExecutionEnvironmentBuilder target(@Nullable ExecutionTarget target) {
        if (target != null) {
            this.myTarget = target;
        }
        return this;
    }

    public ExecutionEnvironmentBuilder activeTarget() {
        this.myTarget = ExecutionTargetManager.getActiveTarget(this.myProject);
        return this;
    }

    public ExecutionEnvironmentBuilder runnerAndSettings(@NotNull ProgramRunner runner, @NotNull RunnerAndConfigurationSettings settings) {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "runnerAndSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "runnerAndSettings"));
        }
        this.myRunnerAndConfigurationSettings = settings;
        this.myRunProfile = settings.getConfiguration();
        this.myRunnerSettings = settings.getRunnerSettings(runner);
        this.myConfigurationSettings = settings.getConfigurationSettings(runner);
        this.myRunner = runner;
        return this;
    }

    public ExecutionEnvironmentBuilder runnerSettings(@Nullable RunnerSettings runnerSettings) {
        this.myRunnerSettings = runnerSettings;
        return this;
    }

    public ExecutionEnvironmentBuilder contentToReuse(@Nullable RunContentDescriptor contentToReuse) {
        this.myContentToReuse = contentToReuse;
        return this;
    }

    public ExecutionEnvironmentBuilder runProfile(@NotNull RunProfile runProfile) {
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "runProfile"));
        }
        this.myRunProfile = runProfile;
        return this;
    }

    public ExecutionEnvironmentBuilder runner(@NotNull ProgramRunner<?> runner) {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "runner"));
        }
        this.myRunner = runner;
        return this;
    }

    public ExecutionEnvironmentBuilder dataContext(@Nullable DataContext dataContext) {
        this.myDataContext = dataContext;
        return this;
    }

    public ExecutionEnvironmentBuilder executor(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "executor"));
        }
        this.myExecutor = executor;
        return this;
    }

    @NotNull
    public ExecutionEnvironment build() {
        if (this.myRunner == null) {
            this.myRunner = this.myRunnerId == null ? RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), this.myRunProfile) : RunnerRegistry.getInstance().findRunnerById(this.myRunnerId);
        }
        if (this.myRunner == null) {
            throw new IllegalStateException("Runner must be specified");
        }
        ExecutionEnvironment environment = new ExecutionEnvironment(this.myRunProfile, this.myExecutor, this.myTarget, this.myProject, this.myRunnerSettings, this.myConfigurationSettings, this.myContentToReuse, this.myRunnerAndConfigurationSettings, this.myRunner);
        if (this.myAssignNewId) {
            environment.assignNewExecutionId();
        }
        if (this.myDataContext != null) {
            environment.setDataContext(this.myDataContext);
        }
        this.myUserData.copyUserDataTo((UserDataHolderBase)environment);
        ExecutionEnvironment executionEnvironment = environment;
        if (executionEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/ExecutionEnvironmentBuilder", "build"));
        }
        return executionEnvironment;
    }

    public void buildAndExecute() throws ExecutionException {
        ExecutionEnvironment environment = this.build();
        this.myRunner.execute(environment);
    }
}

