/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaSdk
extends SdkType
implements JavaSdkType {
    public JavaSdk(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/projectRoots/JavaSdk", "<init>"));
        }
        super(name);
    }

    public static JavaSdk getInstance() {
        return ApplicationManager.getApplication().getComponent(JavaSdk.class);
    }

    @NotNull
    public final Sdk createJdk(@NotNull String jdkName, @NotNull String jreHome) {
        if (jdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkName", "com/intellij/openapi/projectRoots/JavaSdk", "createJdk"));
        }
        if (jreHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jreHome", "com/intellij/openapi/projectRoots/JavaSdk", "createJdk"));
        }
        Sdk sdk = this.createJdk(jdkName, jreHome, true);
        if (sdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JavaSdk", "createJdk"));
        }
        return sdk;
    }

    public abstract int compareTo(@NotNull String var1, @NotNull String var2);

    @NotNull
    public abstract Sdk createJdk(@NonNls String var1, @NotNull String var2, boolean var3);

    @Nullable
    public abstract JavaSdkVersion getVersion(@NotNull Sdk var1);

    @Nullable
    public abstract JavaSdkVersion getVersion(@NotNull String var1);

    public abstract boolean isOfVersionOrHigher(@NotNull Sdk var1, @NotNull JavaSdkVersion var2);

    public static boolean checkForJdk(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/projectRoots/JavaSdk", "checkForJdk"));
        }
        return JdkUtil.checkForJdk(file);
    }

    public static boolean checkForJre(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/projectRoots/JavaSdk", "checkForJre"));
        }
        return JdkUtil.checkForJre(file);
    }

    @Nullable
    public static String getJdkVersion(@NotNull String sdkHome) {
        if (sdkHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHome", "com/intellij/openapi/projectRoots/JavaSdk", "getJdkVersion"));
        }
        return SdkVersionUtil.detectJdkVersion(sdkHome);
    }
}

