/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MessageType {
    public static MessageType ERROR = new MessageType(AllIcons.General.NotificationError, (Color)new JBColor(0xFFCCCC, 7358277), (Color)new JBColor(11272211, 15687525));
    public static MessageType INFO = new MessageType(AllIcons.General.NotificationInfo, (Color)new JBColor(0xBAEEBA, 3359022), (Color)new JBColor(0, 0xBBBBBB));
    public static MessageType WARNING = new MessageType(AllIcons.General.NotificationWarning, (Color)new JBColor(16381838, 5919265), (Color)new JBColor(10785106, 12301609));
    private final Icon myDefaultIcon;
    private final Color myPopupBackground;
    @NotNull
    private final Color myForeground;

    private MessageType(@NotNull Icon defaultIcon, @NotNull Color popupBackground, @NotNull Color foreground) {
        if (defaultIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultIcon", "com/intellij/openapi/ui/MessageType", "<init>"));
        }
        if (popupBackground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupBackground", "com/intellij/openapi/ui/MessageType", "<init>"));
        }
        if (foreground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreground", "com/intellij/openapi/ui/MessageType", "<init>"));
        }
        this.myDefaultIcon = defaultIcon;
        this.myPopupBackground = popupBackground;
        this.myForeground = foreground;
    }

    @NotNull
    public Icon getDefaultIcon() {
        Icon icon = this.myDefaultIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageType", "getDefaultIcon"));
        }
        return icon;
    }

    @NotNull
    public Color getPopupBackground() {
        Color color = this.myPopupBackground;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageType", "getPopupBackground"));
        }
        return color;
    }

    public Color getTitleForeground() {
        return this.myForeground;
    }

    @NotNull
    public NotificationType toNotificationType() {
        NotificationType notificationType = this == ERROR ? NotificationType.ERROR : (this == WARNING ? NotificationType.WARNING : NotificationType.INFORMATION);
        if (notificationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageType", "toNotificationType"));
        }
        return notificationType;
    }
}

