/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.Equality;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public abstract class NamedItemsListEditor<T>
extends MasterDetailsComponent {
    private final Namer<T> myNamer;
    private final Factory<T> myFactory;
    private final Cloner<T> myCloner;
    private final List<T> myItems = new ArrayList<T>();
    private final Equality<T> myComparer;
    private List<T> myResultItems;
    private final List<T> myOriginalItems;
    private boolean myShowIcons;

    protected NamedItemsListEditor(Namer<T> namer, Factory<T> factory, Cloner<T> cloner, Equality<T> comparer, List<T> items) {
        this(namer, factory, cloner, comparer, items, true);
    }

    protected NamedItemsListEditor(Namer<T> namer, Factory<T> factory, Cloner<T> cloner, Equality<T> comparer, List<T> items, boolean initInConstructor) {
        this.myNamer = namer;
        this.myFactory = factory;
        this.myCloner = cloner;
        this.myComparer = comparer;
        this.myOriginalItems = items;
        this.myResultItems = items;
        if (initInConstructor) {
            this.reset();
            this.initTree();
        }
    }

    @Override
    public void reset() {
        this.myResultItems = this.myOriginalItems;
        this.myItems.clear();
        this.clearChildren();
        for (T item : this.myOriginalItems) {
            this.addNewNode(this.myCloner.cloneOf(item));
        }
        super.reset();
    }

    @Override
    protected void processRemovedItems() {
    }

    @Override
    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    protected String subjDisplayName() {
        return "item";
    }

    @Nullable
    public String askForProfileName(String titlePattern) {
        String title = MessageFormat.format(titlePattern, this.subjDisplayName());
        return Messages.showInputDialog("New " + this.subjDisplayName() + " name:", title, Messages.getQuestionIcon(), "", new InputValidator(){

            @Override
            public boolean checkInput(String s) {
                return s.length() > 0 && NamedItemsListEditor.this.findByName(s) == null;
            }

            @Override
            public boolean canClose(String s) {
                return this.checkInput(s);
            }
        });
    }

    @Nullable
    protected T findByName(String name) {
        for (T item : this.myItems) {
            if (!Comparing.equal((String)name, (String)this.myNamer.getName(item))) continue;
            return item;
        }
        return null;
    }

    @Override
    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(new AddAction());
        result.add(new MasterDetailsComponent.MyDeleteAction(NamedItemsListEditor.forAll((Condition<Object>)((Condition)o -> this.canDelete(((MasterDetailsComponent.MyNode)o).getConfigurable().getEditableObject())))));
        result.add(new CopyAction());
        return result;
    }

    private void addNewNode(T item) {
        this.addNode(new MasterDetailsComponent.MyNode(new ItemConfigurable(item)), this.myRoot);
        this.myItems.add(item);
    }

    protected boolean canDelete(T item) {
        return true;
    }

    protected abstract UnnamedConfigurable createConfigurable(T var1);

    @Override
    protected void onItemDeleted(Object item) {
        this.myItems.remove(item);
    }

    protected void setDisplayName(T item, String name) {
        this.myNamer.setName(item, name);
    }

    public void setShowIcons(boolean showIcons) {
        this.myShowIcons = showIcons;
    }

    @Nullable
    protected UnnamedConfigurable getItemConfigurable(final T item) {
        final Ref result = new Ref();
        TreeUtil.traverse((TreeNode)this.myTree.getModel().getRoot(), new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                NamedConfigurable configurable = (NamedConfigurable)((DefaultMutableTreeNode)node).getUserObject();
                if (configurable.getEditableObject() == item) {
                    result.set((Object)((ItemConfigurable)configurable).myConfigurable);
                    return false;
                }
                return true;
            }
        });
        return (UnnamedConfigurable)result.get();
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
    }

    @Override
    public boolean isModified() {
        if (this.myResultItems.size() != this.myItems.size()) {
            return true;
        }
        for (int i = 0; i < this.myItems.size(); ++i) {
            if (this.myComparer.equals(this.myItems.get(i), this.myResultItems.get(i))) continue;
            return true;
        }
        return super.isModified();
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        this.myResultItems = this.myItems;
    }

    protected List<T> getCurrentItems() {
        return Collections.unmodifiableList(this.myItems);
    }

    public List<T> getItems() {
        return this.myResultItems;
    }

    public T getSelectedItem() {
        return (T)this.getSelectedObject();
    }

    protected void onItemCloned(T clone) {
    }

    public void selectItem(T item) {
        this.selectNodeInTree(this.findByName(this.myNamer.getName(item)));
    }

    @Nullable
    protected T createItem() {
        String name = this.askForProfileName("Create new {0}");
        if (name == null) {
            return null;
        }
        Object newItem = this.myFactory.create();
        this.myNamer.setName(newItem, name);
        return (T)newItem;
    }

    protected void onItemCreated(T newItem) {
        this.addNewNode(newItem);
        this.selectNodeInTree(newItem);
    }

    private class AddAction
    extends DumbAwareAction {
        public AddAction() {
            super("Add", "Add", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, NamedItemsListEditor.this.myTree);
        }

        @Override
        public void actionPerformed(AnActionEvent event) {
            Object newItem = NamedItemsListEditor.this.createItem();
            if (newItem != null) {
                NamedItemsListEditor.this.onItemCreated(newItem);
            }
        }
    }

    private class CopyAction
    extends DumbAwareAction {
        public CopyAction() {
            super("Copy", "Copy", MasterDetailsComponent.COPY_ICON);
            this.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(68, 2)), NamedItemsListEditor.this.myTree);
        }

        @Override
        public void actionPerformed(AnActionEvent event) {
            String profileName = NamedItemsListEditor.this.askForProfileName("Copy {0}");
            if (profileName == null) {
                return;
            }
            Object clone = NamedItemsListEditor.this.myCloner.copyOf(NamedItemsListEditor.this.getSelectedObject());
            NamedItemsListEditor.this.myNamer.setName(clone, profileName);
            NamedItemsListEditor.this.addNewNode(clone);
            NamedItemsListEditor.this.selectNodeInTree(clone);
            NamedItemsListEditor.this.onItemCloned(clone);
        }

        @Override
        public void update(AnActionEvent event) {
            super.update(event);
            event.getPresentation().setEnabled(NamedItemsListEditor.this.getSelectedObject() != null);
        }
    }

    private class ItemConfigurable
    extends NamedConfigurable {
        private final T myItem;
        private final UnnamedConfigurable myConfigurable;

        public ItemConfigurable(T item) {
            super(NamedItemsListEditor.this.myNamer.canRename(item), NamedItemsListEditor.this.TREE_UPDATER);
            this.myItem = item;
            this.myConfigurable = NamedItemsListEditor.this.createConfigurable(item);
        }

        @Override
        public void setDisplayName(String name) {
            NamedItemsListEditor.this.setDisplayName(this.myItem, name);
        }

        public Object getEditableObject() {
            return this.myItem;
        }

        @Override
        public String getBannerSlogan() {
            return NamedItemsListEditor.this.myNamer.getName(this.myItem);
        }

        @Override
        public JComponent createOptionsPanel() {
            return this.myConfigurable.createComponent();
        }

        @Override
        public String getDisplayName() {
            return NamedItemsListEditor.this.myNamer.getName(this.myItem);
        }

        @Override
        public Icon getIcon(boolean expanded) {
            if (NamedItemsListEditor.this.myShowIcons && this.myConfigurable instanceof Iconable) {
                return ((Iconable)((Object)this.myConfigurable)).getIcon(0);
            }
            return null;
        }

        @Override
        public String getHelpTopic() {
            return null;
        }

        @Override
        public boolean isModified() {
            return this.myConfigurable.isModified();
        }

        @Override
        public void apply() throws ConfigurationException {
            this.myConfigurable.apply();
        }

        @Override
        public void reset() {
            this.myConfigurable.reset();
        }

        @Override
        public void disposeUIResources() {
            this.myConfigurable.disposeUIResources();
        }
    }
}

