/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public abstract class LiteralTextEscaper<T extends PsiLanguageInjectionHost> {
    protected final T myHost;

    protected LiteralTextEscaper(@NotNull T host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/LiteralTextEscaper", "<init>"));
        }
        this.myHost = host;
    }

    public abstract boolean decode(@NotNull TextRange var1, @NotNull StringBuilder var2);

    public abstract int getOffsetInHost(int var1, @NotNull TextRange var2);

    @NotNull
    public TextRange getRelevantTextRange() {
        TextRange textRange = TextRange.from((int)0, (int)this.myHost.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LiteralTextEscaper", "getRelevantTextRange"));
        }
        return textRange;
    }

    public abstract boolean isOneLine();

    public static <T extends PsiLanguageInjectionHost> LiteralTextEscaper<T> createSimple(T element) {
        return new LiteralTextEscaper<T>(element){

            @Override
            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                if (rangeInsideHost == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/LiteralTextEscaper$1", "decode"));
                }
                if (outChars == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/psi/LiteralTextEscaper$1", "decode"));
                }
                outChars.append(rangeInsideHost.substring(this.myHost.getText()));
                return true;
            }

            @Override
            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                if (rangeInsideHost == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/LiteralTextEscaper$1", "getOffsetInHost"));
                }
                return rangeInsideHost.getStartOffset() + offsetInDecoded;
            }

            @Override
            public boolean isOneLine() {
                return true;
            }
        };
    }
}

