/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class PsiArrayType
extends PsiType.Stub {
    private final PsiType myComponentType;

    public PsiArrayType(@NotNull PsiType componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/psi/PsiArrayType", "<init>"));
        }
        this(componentType, TypeAnnotationProvider.EMPTY);
    }

    public PsiArrayType(@NotNull PsiType componentType, @NotNull PsiAnnotation[] annotations) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/psi/PsiArrayType", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiArrayType", "<init>"));
        }
        super(annotations);
        this.myComponentType = componentType;
    }

    public PsiArrayType(@NotNull PsiType componentType, @NotNull TypeAnnotationProvider provider) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/psi/PsiArrayType", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/PsiArrayType", "<init>"));
        }
        super(provider);
        this.myComponentType = componentType;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getText(this.myComponentType.getPresentableText(), "[]", false, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiArrayType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(this.myComponentType.getCanonicalText(annotated), "[]", true, annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiArrayType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(this.myComponentType.getInternalCanonicalText(), "[]", true, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiArrayType", "getInternalCanonicalText"));
        }
        return string;
    }

    protected String getText(@NotNull String prefix, @NotNull String suffix, boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/PsiArrayType", "getText"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/PsiArrayType", "getText"));
        }
        StringBuilder sb = new StringBuilder(prefix.length() + suffix.length());
        sb.append(prefix);
        if (annotated && (annotations = this.getAnnotations()).length != 0) {
            sb.append(' ');
            PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        }
        sb.append(suffix);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return this.myComponentType.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/PsiArrayType", "equalsToText"));
        }
        return text.endsWith("[]") && this.myComponentType.equalsToText(text.substring(0, text.length() - 2));
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiArrayType", "accept"));
        }
        return visitor.visitArrayType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myComponentType.getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] superTypes = this.myComponentType.getSuperTypes();
        PsiType[] result = PsiArrayType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            result[i] = superTypes[i].createArrayType();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiArrayType", "getSuperTypes"));
        }
        return result;
    }

    @NotNull
    public PsiType getComponentType() {
        PsiType psiType = this.myComponentType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiArrayType", "getComponentType"));
        }
        return psiType;
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiArrayType && this instanceof PsiEllipsisType == obj instanceof PsiEllipsisType && this.myComponentType.equals(((PsiArrayType)obj).getComponentType());
    }

    public int hashCode() {
        return this.myComponentType.hashCode() * 3;
    }
}

