/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonRefactoringUtil {
    private CommonRefactoringUtil() {
    }

    public static void showErrorMessage(String title, String message, @Nullable String helpId, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "showErrorMessage"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(title, message, helpId, "OptionPane.errorIcon", false, project);
        dialog.show();
    }

    public static void sortDepthFirstRightLeftOrder(UsageInfo[] usages) {
        Arrays.sort(usages, (usage1, usage2) -> {
            PsiElement element2;
            PsiElement element1 = usage1.getElement();
            if (element1 == (element2 = usage2.getElement())) {
                return 0;
            }
            if (element1 == null) {
                return 1;
            }
            if (element2 == null) {
                return -1;
            }
            return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
        });
    }

    public static void showErrorHint(@NotNull Project project, @Nullable Editor editor, @NotNull @Nls String message, @NotNull @Nls String title, @Nullable String helpId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "showErrorHint"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/refactoring/util/CommonRefactoringUtil", "showErrorHint"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/refactoring/util/CommonRefactoringUtil", "showErrorHint"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RefactoringErrorHintException(message);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/refactoring/util/CommonRefactoringUtil", "lambda$showErrorHint$1"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/refactoring/util/CommonRefactoringUtil", "lambda$showErrorHint$1"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "lambda$showErrorHint$1"));
            }
            if (editor == null || editor.getComponent().getRootPane() == null) {
                CommonRefactoringUtil.showErrorMessage(title, message, helpId, project);
            } else {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }

    public static String htmlEmphasize(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/refactoring/util/CommonRefactoringUtil", "htmlEmphasize"));
        }
        return StringUtil.htmlEmphasize((String)text);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        return file != null && !ReadonlyStatusHandler.getInstance(element.getProject()).ensureFilesWritable(file).hasReadonlyFiles();
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(element, project, RefactoringBundle.message("refactoring.cannot.be.performed"));
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, PsiElement ... elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), Arrays.asList(elements), RefactoringBundle.message("refactoring.cannot.be.performed"), true);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), elements, RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @NotNull Project project, @NotNull String messagePrefix) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (messagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagePrefix", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return element.isWritable() || CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), Collections.singleton(element), messagePrefix, true);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatusRecursively"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatusRecursively"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, elements, Collections.emptySet(), RefactoringBundle.message("refactoring.cannot.be.performed"), false);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatusRecursively"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatusRecursively"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, elements, Collections.emptySet(), RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> recursive, @NotNull Collection<? extends PsiElement> flat, boolean notifyOnFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (recursive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursive", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (flat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flat", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, recursive, flat, RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    private static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> recursive, @NotNull Collection<? extends PsiElement> flat, @NotNull String messagePrefix, boolean notifyOnFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (recursive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursive", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (flat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flat", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (messagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagePrefix", "com/intellij/refactoring/util/CommonRefactoringUtil", "checkReadOnlyStatus"));
        }
        THashSet readonly = new THashSet();
        THashSet failed = new THashSet();
        boolean seenNonWritablePsiFilesWithoutVirtualFile = CommonRefactoringUtil.checkReadOnlyStatus(flat, false, (Collection<VirtualFile>)readonly, (Collection<VirtualFile>)failed) || CommonRefactoringUtil.checkReadOnlyStatus(recursive, true, (Collection<VirtualFile>)readonly, (Collection<VirtualFile>)failed);
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable((Collection<VirtualFile>)readonly);
        ContainerUtil.addAll((Collection)failed, (Object[])status.getReadonlyFiles());
        if (notifyOnFail && (!failed.isEmpty() || seenNonWritablePsiFilesWithoutVirtualFile && readonly.isEmpty())) {
            StringBuilder message = new StringBuilder(messagePrefix).append('\n');
            int i = 0;
            for (VirtualFile virtualFile : failed) {
                String subj = RefactoringBundle.message(virtualFile.isDirectory() ? "directory.description" : "file.description", virtualFile.getPresentableUrl());
                if (virtualFile.getFileSystem().isReadOnly()) {
                    message.append(RefactoringBundle.message("0.is.located.in.a.jar.file", subj)).append('\n');
                } else {
                    message.append(RefactoringBundle.message("0.is.read.only", subj)).append('\n');
                }
                if (i++ <= 20) continue;
                message.append("...\n");
                break;
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("error.title"), message.toString(), null, project);
            return false;
        }
        return failed.isEmpty();
    }

    private static boolean checkReadOnlyStatus(Collection<? extends PsiElement> elements, boolean recursively, Collection<VirtualFile> readonly, Collection<VirtualFile> failed) {
        boolean seenNonWritablePsiFilesWithoutVirtualFile = false;
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)psiElement;
                VirtualFile virtualFile = dir.getVirtualFile();
                if (virtualFile.getFileSystem().isReadOnly()) {
                    failed.add(virtualFile);
                    continue;
                }
                if (recursively) {
                    CommonRefactoringUtil.collectReadOnlyFiles(virtualFile, readonly);
                    continue;
                }
                readonly.add(virtualFile);
                continue;
            }
            if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                for (PsiDirectory directory : directories = ((PsiDirectoryContainer)psiElement).getDirectories()) {
                    VirtualFile virtualFile = directory.getVirtualFile();
                    if (recursively) {
                        if (virtualFile.getFileSystem().isReadOnly()) {
                            failed.add(virtualFile);
                            continue;
                        }
                        CommonRefactoringUtil.collectReadOnlyFiles(virtualFile, readonly);
                        continue;
                    }
                    if (virtualFile.getFileSystem().isReadOnly()) {
                        failed.add(virtualFile);
                        continue;
                    }
                    readonly.add(virtualFile);
                }
                continue;
            }
            PsiFile file = psiElement.getContainingFile();
            if (file == null) {
                if (psiElement.isWritable()) continue;
                seenNonWritablePsiFilesWithoutVirtualFile = true;
                continue;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                readonly.add(virtualFile);
                continue;
            }
            if (psiElement.isWritable()) continue;
            seenNonWritablePsiFilesWithoutVirtualFile = true;
        }
        return seenNonWritablePsiFilesWithoutVirtualFile;
    }

    public static void collectReadOnlyFiles(@NotNull VirtualFile vFile, final @NotNull Collection<VirtualFile> list) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/refactoring/util/CommonRefactoringUtil", "collectReadOnlyFiles"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/refactoring/util/CommonRefactoringUtil", "collectReadOnlyFiles"));
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/util/CommonRefactoringUtil$1", "visitFile"));
                }
                boolean ignored = fileTypeManager.isFileIgnored(file);
                if (!file.isWritable() && !ignored) {
                    list.add(file);
                }
                return !ignored;
            }
        });
    }

    public static String capitalize(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/refactoring/util/CommonRefactoringUtil", "capitalize"));
        }
        return StringUtil.capitalize((String)text);
    }

    public static boolean isAncestor(@NotNull PsiElement resolved, @NotNull Collection<? extends PsiElement> scopes) {
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "com/intellij/refactoring/util/CommonRefactoringUtil", "isAncestor"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "com/intellij/refactoring/util/CommonRefactoringUtil", "isAncestor"));
        }
        for (PsiElement psiElement : scopes) {
            if (!PsiTreeUtil.isAncestor(psiElement, resolved, false)) continue;
            return true;
        }
        return false;
    }

    public static class RefactoringErrorHintException
    extends RuntimeException {
        public RefactoringErrorHintException(String message) {
            super(message);
        }
    }
}

