/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class BooleanTableCellRenderer
extends JCheckBox
implements TableCellRenderer {
    private final JPanel myPanel = new JPanel();

    public BooleanTableCellRenderer() {
        this(0);
    }

    public BooleanTableCellRenderer(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.setVerticalAlignment(0);
        this.setBorder(null);
        this.setOpaque(true);
        this.myPanel.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        Color bg = UIUtil.isUnderNimbusLookAndFeel() && row % 2 == 1 ? UIUtil.TRANSPARENT_COLOR : table.getBackground();
        Color fg = table.getForeground();
        Color selBg = table.getSelectionBackground();
        Color selFg = table.getSelectionForeground();
        if (value == null) {
            this.myPanel.setBackground(isSel ? selBg : bg);
            return this.myPanel;
        }
        this.setForeground(isSel ? selFg : fg);
        this.setBackground(isSel ? selBg : bg);
        if (value instanceof String) {
            this.setSelected(Boolean.parseBoolean((String)value));
        } else {
            this.setSelected((Boolean)value);
        }
        this.setEnabled(table.isCellEditable(row, column));
        return this;
    }
}

