/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.MacScrollBarUI;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.RegionPainter;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;

public class JBScrollBar
extends JScrollBar {
    public static final Key<RegionPainter<Object>> TRACK = Key.create((String)"JB_SCROLL_BAR_TRACK");

    public JBScrollBar() {
        this(1);
    }

    public JBScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public JBScrollBar(@JdkConstants.AdjustableOrientation int orientation, int value, int extent, int min, int max) {
        super(orientation, value, extent, min, max);
        this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
    }

    @Override
    public void updateUI() {
        ScrollBarUI ui = this.getUI();
        if (ui instanceof DefaultScrollBarUI) {
            return;
        }
        this.setUI(JBScrollBar.createUI(this));
    }

    public static ScrollBarUI createUI(JComponent c) {
        if (Registry.is((String)"ide.scroll.new.layout")) {
            if (!SystemInfo.isMac) {
                return new DefaultScrollBarUI();
            }
            if (Registry.is((String)"mac.scroll.new.ui")) {
                return new MacScrollBarUI();
            }
        }
        return ButtonlessScrollBarUI.createNormal();
    }
}

