/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.switcher.QuickActionManager;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.switcher.SwitchManager;
import java.util.List;

public class ApplySwitchAction
extends AnAction {
    @Override
    public void update(AnActionEvent e) {
        boolean switchActionActive;
        Project project = ApplySwitchAction.getEventProject(e);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        SwitchManager mgr = SwitchManager.getInstance(project);
        boolean bl = switchActionActive = mgr != null && mgr.isSessionActive();
        if (switchActionActive && mgr.isSelectionWasMoved()) {
            e.getPresentation().setEnabled(true);
        } else {
            QuickActionProvider quickActionProvider = QuickActionProvider.KEY.getData(e.getDataContext());
            if (quickActionProvider == null) {
                e.getPresentation().setEnabled(false);
            } else {
                List<AnAction> actions = quickActionProvider.getActions(true);
                e.getPresentation().setEnabled(actions != null && !actions.isEmpty());
            }
        }
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = ApplySwitchAction.getEventProject(e);
        SwitchManager switchManager = SwitchManager.getInstance(project);
        if (switchManager.canApplySwitch()) {
            switchManager.applySwitch();
        } else {
            switchManager.disposeCurrentSession(false);
            QuickActionManager.getInstance(project).showQuickActions();
        }
    }
}

