/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import org.jetbrains.annotations.NotNull;

public final class TimedDeadzone {
    public static final Length DEFAULT = new Length(150);
    public static final Length NULL = new Length(-1);
    private Length myLength = NULL;
    private boolean myWithin;
    private long myEntered = -1L;

    public TimedDeadzone(Length zoneLength) {
        this.myLength = zoneLength;
    }

    public int getLength() {
        return this.myLength.getLength();
    }

    public void enter() {
        if (!this.isWithin()) {
            this.reEnter();
        }
    }

    public void reEnter() {
        if (this.myLength == NULL) {
            this.clear();
            return;
        }
        this.myEntered = System.currentTimeMillis();
        this.myWithin = true;
    }

    public void clear() {
        this.myWithin = false;
    }

    public boolean isWithin() {
        if (this.myWithin && System.currentTimeMillis() - this.myEntered > (long)this.getLength()) {
            this.myWithin = false;
        }
        return this.myWithin;
    }

    public void setLength(@NotNull Length deadZone) {
        if (deadZone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deadZone", "com/intellij/util/ui/TimedDeadzone", "setLength"));
        }
        this.myLength = deadZone;
    }

    public static class Length {
        private final int myLength;

        public Length(int length) {
            this.myLength = length;
        }

        public int getLength() {
            return this.myLength;
        }
    }
}

