/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelimitedListConverter<T>
extends ResolvingConverter<List<T>>
implements CustomReferenceConverter<List<T>> {
    protected static final Object[] EMPTY_ARRAY = ArrayUtil.EMPTY_OBJECT_ARRAY;
    private final String myDelimiters;

    public DelimitedListConverter(@NonNls @NotNull String delimiters) {
        if (delimiters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiters", "com/intellij/util/xml/converters/DelimitedListConverter", "<init>"));
        }
        this.myDelimiters = delimiters;
    }

    @Nullable
    protected abstract T convertString(@Nullable String var1, ConvertContext var2);

    @Nullable
    protected abstract String toString(@Nullable T var1);

    protected abstract Object[] getReferenceVariants(ConvertContext var1, GenericDomValue<List<T>> var2);

    @Nullable
    protected abstract PsiElement resolveReference(@Nullable T var1, ConvertContext var2);

    protected abstract String getUnresolvedMessage(String var1);

    @Override
    @NotNull
    public Collection<? extends List<T>> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/DelimitedListConverter", "getVariants"));
        }
        return list;
    }

    public static <T> void filterVariants(List<T> variants, GenericDomValue<List<T>> genericDomValue) {
        List list = (List)genericDomValue.getValue();
        if (list != null) {
            Iterator<T> i = variants.iterator();
            block0: while (i.hasNext()) {
                T variant = i.next();
                for (Object existing : list) {
                    if (!existing.equals(variant)) continue;
                    i.remove();
                    continue block0;
                }
            }
        }
    }

    protected char getDefaultDelimiter() {
        return this.myDelimiters.charAt(0);
    }

    @Override
    public List<T> fromString(@Nullable String str, ConvertContext context) {
        if (str == null) {
            return null;
        }
        ArrayList<T> values = new ArrayList<T>();
        for (String s : StringUtil.tokenize((String)str, (String)this.myDelimiters)) {
            T t = this.convertString(s.trim(), context);
            if (t == null) continue;
            values.add(t);
        }
        return values;
    }

    @Override
    public String toString(List<T> ts, ConvertContext context) {
        StringBuilder buffer = new StringBuilder();
        char delimiter = this.getDefaultDelimiter();
        for (T t : ts) {
            String s = this.toString(t);
            if (s == null) continue;
            if (buffer.length() != 0) {
                buffer.append(delimiter);
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    @Override
    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<List<T>> genericDomValue, final PsiElement element, final ConvertContext context) {
        String text = genericDomValue.getRawText();
        if (text == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/DelimitedListConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final ArrayList references = new ArrayList();
        new DelimitedListProcessor(this.myDelimiters){

            protected void processToken(int start, int end, boolean delimitersOnly) {
                references.add(DelimitedListConverter.this.createPsiReference(element, start + 1, end + 1, context, genericDomValue, delimitersOnly));
            }
        }.processText(text);
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/DelimitedListConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start, int end, ConvertContext context, GenericDomValue<List<T>> genericDomValue, boolean delimitersOnly) {
        MyPsiReference myPsiReference = new MyPsiReference(element, this.getTextRange(genericDomValue, start, end), context, genericDomValue, delimitersOnly);
        if (myPsiReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/DelimitedListConverter", "createPsiReference"));
        }
        return myPsiReference;
    }

    protected TextRange getTextRange(GenericDomValue value, int start, int end) {
        if (value instanceof GenericAttributeValue) {
            return new TextRange(start, end);
        }
        TextRange tagRange = XmlTagUtil.getTrimmedValueRange(value.getXmlTag());
        return new TextRange(tagRange.getStartOffset() + start - 1, tagRange.getStartOffset() + end - 1);
    }

    public String toString() {
        return super.toString() + " delimiters: " + this.myDelimiters;
    }

    protected PsiElement referenceBindToElement(PsiReference psiReference, PsiElement element, Function<PsiElement, PsiElement> superBindToElementFunction, Function<String, PsiElement> superElementRenameFunction) throws IncorrectOperationException {
        return (PsiElement)superBindToElementFunction.fun((Object)element);
    }

    protected PsiElement referenceHandleElementRename(PsiReference psiReference, String newName, Function<String, PsiElement> superHandleElementRename) throws IncorrectOperationException {
        return (PsiElement)superHandleElementRename.fun((Object)newName);
    }

    protected class MyPsiReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        protected final ConvertContext myContext;
        protected final GenericDomValue<List<T>> myGenericDomValue;
        private final boolean myDelimitersOnly;

        public MyPsiReference(PsiElement element, TextRange range, ConvertContext context, GenericDomValue<List<T>> genericDomValue, boolean delimitersOnly) {
            this(element, range, context, genericDomValue, true, delimitersOnly);
        }

        public MyPsiReference(PsiElement element, TextRange range, ConvertContext context, GenericDomValue<List<T>> genericDomValue, boolean soft, boolean delimitersOnly) {
            super(element, range, soft);
            this.myContext = context;
            this.myGenericDomValue = genericDomValue;
            this.myDelimitersOnly = delimitersOnly;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            if (this.myDelimitersOnly) {
                return this.getElement();
            }
            String value = this.getValue();
            return DelimitedListConverter.this.resolveReference(DelimitedListConverter.this.convertString(value, this.myContext), this.myContext);
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = DelimitedListConverter.this.getReferenceVariants(this.myContext, this.myGenericDomValue);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/DelimitedListConverter$MyPsiReference", "getVariants"));
            }
            return objectArray;
        }

        @Override
        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            Ref ref = new Ref();
            PsiElement element = DelimitedListConverter.this.referenceHandleElementRename(this, newElementName, this.getSuperElementRenameFunction((Ref<IncorrectOperationException>)ref));
            if (!ref.isNull()) {
                throw (IncorrectOperationException)((Object)ref.get());
            }
            return element;
        }

        @Override
        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/converters/DelimitedListConverter$MyPsiReference", "bindToElement"));
            }
            Ref ref = new Ref();
            PsiElement bindElement = DelimitedListConverter.this.referenceBindToElement(this, element, this.getSuperBindToElementFunction((Ref<IncorrectOperationException>)ref), this.getSuperElementRenameFunction((Ref<IncorrectOperationException>)ref));
            if (!ref.isNull()) {
                throw (IncorrectOperationException)((Object)ref.get());
            }
            return bindElement;
        }

        @Override
        public String toString() {
            return super.toString() + " converter: " + DelimitedListConverter.this;
        }

        private Function<PsiElement, PsiElement> getSuperBindToElementFunction(Ref<IncorrectOperationException> ref) {
            return s -> {
                try {
                    return MyPsiReference.super.bindToElement(s);
                }
                catch (IncorrectOperationException e) {
                    ref.set((Object)e);
                    return null;
                }
            };
        }

        private Function<String, PsiElement> getSuperElementRenameFunction(Ref<IncorrectOperationException> ref) {
            return s -> {
                try {
                    return MyPsiReference.super.handleElementRename(s);
                }
                catch (IncorrectOperationException e) {
                    ref.set((Object)e);
                    return null;
                }
            };
        }

        @Override
        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = DelimitedListConverter.this.getUnresolvedMessage(this.getValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/DelimitedListConverter$MyPsiReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

