/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import java.util.Date;
import org.tigris.subversion.javahl.NodeKind;
import org.tigris.subversion.javahl.Revision;

public class DirEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long lastChanged;
    private long lastChangedRevision;
    private boolean hasProps;
    private String lastAuthor;
    private int nodeKind;
    private long size;
    private String path;
    private String absPath;

    DirEntry(String path, String absPath, int nodeKind, long size, boolean hasProps, long lastChangedRevision, long lastChanged, String lastAuthor) {
        this.path = path;
        this.absPath = absPath;
        this.nodeKind = nodeKind;
        this.size = size;
        this.hasProps = hasProps;
        this.lastChangedRevision = lastChangedRevision;
        this.lastChanged = lastChanged;
        this.lastAuthor = lastAuthor;
    }

    DirEntry(org.apache.subversion.javahl.types.DirEntry aEntry) {
        this(aEntry.getPath(), aEntry.getAbsPath(), NodeKind.fromApache(aEntry.getNodeKind()), aEntry.getSize(), aEntry.getHasProps(), aEntry.getLastChangedRevisionNumber(), aEntry.getLastChanged().getTime() * 1000L, aEntry.getLastAuthor());
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsPath() {
        return this.absPath;
    }

    public Date getLastChanged() {
        return new Date(this.lastChanged / 1000L);
    }

    public Revision.Number getLastChangedRevision() {
        return Revision.createNumber(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public boolean getHasProps() {
        return this.hasProps;
    }

    public String getLastAuthor() {
        return this.lastAuthor;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public long getSize() {
        return this.size;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return this.getPath() + '@' + this.getLastChangedRevision();
    }

    public class Fields {
        public static final int nodeKind = 1;
        public static final int size = 2;
        public static final int hasProps = 4;
        public static final int lastChangeRevision = 8;
        public static final int lastChanged = 16;
        public static final int lastAuthor = 32;
        public static final int all = -1;
    }
}

