/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.MethodDeclaration;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;

public class HandlerDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("HandlerLeak", "Handler reference leaks", "Since this Handler is declared as an inner class, it may prevent the outer class from being garbage collected. If the Handler is using a Looper or MessageQueue for a thread other than the main thread, then there is no issue. If the Handler is using the Looper or MessageQueue of the main thread, you need to fix your Handler declaration, as follows: Declare the Handler as a static class; In the outer class, instantiate a WeakReference to the outer class and pass this object to your Handler when you instantiate the Handler; Make all references to members of the outer class using the WeakReference object.", Category.PERFORMANCE, 4, Severity.WARNING, new Implementation(HandlerDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String LOOPER_CLS = "android.os.Looper";
    private static final String HANDLER_CLS = "android.os.Handler";

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(HANDLER_CLS);
    }

    @Override
    public void checkClass(JavaContext context, ClassDeclaration declaration, Node node, JavaParser.ResolvedClass cls) {
        Location location;
        Node locationNode;
        if (!HandlerDetector.isInnerClass(declaration)) {
            return;
        }
        if (HandlerDetector.isStaticClass(declaration)) {
            return;
        }
        ConstructorInvocation invocation = null;
        for (Node current = node; current != null; current = current.getParent()) {
            if (current instanceof ConstructorInvocation) {
                invocation = (ConstructorInvocation)current;
                break;
            }
            if (current instanceof MethodDeclaration || current instanceof ClassDeclaration) break;
        }
        if (invocation != null) {
            for (Expression expression : invocation.astArguments()) {
                JavaParser.TypeDescriptor type = context.getType((Node)expression);
                if (type == null || !type.matchesName(LOOPER_CLS)) continue;
                return;
            }
        } else if (HandlerDetector.hasLooperConstructorParameter(cls)) {
            return;
        }
        if (node instanceof ClassDeclaration) {
            locationNode = node;
            location = context.getLocation((Node)((ClassDeclaration)node).astName());
        } else if (node instanceof NormalTypeBody && node.getParent() instanceof ConstructorInvocation) {
            ConstructorInvocation parent = (ConstructorInvocation)node.getParent();
            locationNode = parent;
            location = context.getRangeLocation((Node)parent, 0, (Node)parent.astTypeReference(), 0);
        } else {
            locationNode = node;
            location = context.getLocation(node);
        }
        context.report(ISSUE, locationNode, location, String.format("This Handler class should be static or leaks might occur (%1$s)", declaration == null ? "anonymous " + cls.getName() : cls.getName()));
    }

    private static boolean isInnerClass(ClassDeclaration node) {
        return node == null || JavaContext.getParentOfType((Node)node, ClassDeclaration.class, true) != null;
    }

    private static boolean isStaticClass(ClassDeclaration node) {
        if (node == null) {
            return false;
        }
        int flags = node.astModifiers().getEffectiveModifierFlags();
        return (flags & 8) != 0;
    }

    private static boolean hasLooperConstructorParameter(JavaParser.ResolvedClass cls) {
        for (JavaParser.ResolvedMethod constructor : cls.getConstructors()) {
            int n = constructor.getArgumentCount();
            for (int i = 0; i < n; ++i) {
                JavaParser.TypeDescriptor type = constructor.getArgumentType(i);
                if (!type.matchesSignature(LOOPER_CLS)) continue;
                return true;
            }
        }
        return false;
    }
}

