/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TypeEvaluator;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class ViewTagDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("ViewTag", "Tagged object leaks", "Prior to Android 4.0, the implementation of `View.setTag(int, Object)` would store the objects in a static map, where the values were strongly referenced. This means that if the object contains any references pointing back to the context, the context (which points to pretty much everything else) will leak. If you pass a view, the view provides a reference to the context that created it. Similarly, view holders typically contain a view, and cursors are sometimes also associated with views.", Category.PERFORMANCE, 6, Severity.WARNING, new Implementation(ViewTagDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setTag");
    }

    @Override
    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation call) {
        String objectType;
        if (context.getMainProject().getMinSdk() >= 14) {
            return;
        }
        JavaParser.ResolvedNode resolved = context.resolve((Node)call);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        if (method.getArgumentCount() != 2) {
            return;
        }
        Expression tagArgument = (Expression)call.astArguments().last();
        if (tagArgument == null) {
            return;
        }
        JavaParser.ResolvedClass containingClass = method.getContainingClass();
        if (!containingClass.matches("android.view.View")) {
            return;
        }
        JavaParser.TypeDescriptor type = TypeEvaluator.evaluate(context, (Node)tagArgument);
        if (type == null) {
            return;
        }
        JavaParser.ResolvedClass typeClass = type.getTypeClass();
        if (typeClass == null) {
            return;
        }
        if (typeClass.isSubclassOf("android.view.View", false)) {
            objectType = "views";
        } else if (typeClass.isImplementing("android.database.Cursor", false)) {
            objectType = "cursors";
        } else if (typeClass.getSimpleName().endsWith("ViewHolder")) {
            objectType = "view holders";
        } else {
            return;
        }
        String message = String.format("Avoid setting %1$s as values for `setTag`: Can lead to memory leaks in versions older than Android 4.0", objectType);
        context.report(ISSUE, (Node)call, context.getLocation((Node)tagArgument), message);
    }
}

