/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.TaskContainer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class AntIntrospector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.AntIntrospector");
    private final Object myHelper;
    private static final HashMap<Class, Object> ourCache = new HashMap();
    private static final Object ourNullObject = new Object();
    private static final Alarm ourCacheCleaner = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    private static final int CACHE_CLEAN_TIMEOUT = 10000;
    private final Class myTypeClass;

    public AntIntrospector(Class aClass) {
        this.myTypeClass = aClass;
        this.myHelper = AntIntrospector.getHelper(aClass);
    }

    @Nullable
    public static AntIntrospector getInstance(Class c) {
        AntIntrospector antIntrospector = new AntIntrospector(c);
        return antIntrospector.myHelper == null ? null : antIntrospector;
    }

    private <T> T invokeMethod(@NonNls String methodName, boolean ignoreErrors, Object ... params) {
        block9: {
            Class<?> helperClass = this.myHelper.getClass();
            Class[] types = new Class[params.length];
            try {
                for (int idx = 0; idx < params.length; ++idx) {
                    types[idx] = params[idx].getClass();
                }
                Method method = helperClass.getMethod(methodName, types);
                return (T)method.invoke(this.myHelper, params);
            }
            catch (IllegalAccessException e) {
                if (!ignoreErrors) {
                    LOG.error((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                if (!ignoreErrors) {
                    LOG.error((Throwable)e);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (ignoreErrors) break block9;
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public Set<String> getExtensionPointTypes() {
        List methods = (List)this.invokeMethod("getExtensionPoints", true, new Object[0]);
        if (methods == null || methods.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> types = new HashSet<String>();
        for (Method method : methods) {
            Class<?>[] paramTypes;
            for (Class<?> paramType : paramTypes = method.getParameterTypes()) {
                types.add(paramType.getName());
            }
        }
        return types;
    }

    public Enumeration<String> getNestedElements() {
        return (Enumeration)this.invokeMethod("getNestedElements", false, new Object[0]);
    }

    @Nullable
    public Class getElementType(String name) {
        try {
            return (Class)this.invokeMethod("getElementType", false, name);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public Enumeration<String> getAttributes() {
        return (Enumeration)this.invokeMethod("getAttributes", false, new Object[0]);
    }

    @Nullable
    public Class getAttributeType(String attr) {
        try {
            return (Class)this.invokeMethod("getAttributeType", false, attr);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public boolean isContainer() {
        try {
            Object isContainer = this.invokeMethod("isContainer", true, new Object[0]);
            if (isContainer != null) {
                return Boolean.TRUE.equals(isContainer);
            }
            ClassLoader loader = this.myTypeClass.getClassLoader();
            try {
                Class<TaskContainer> containerClass = loader != null ? loader.loadClass(TaskContainer.class.getName()) : TaskContainer.class;
                return containerClass.isAssignableFrom(this.myTypeClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        catch (RuntimeException e) {
            LOG.info((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Object getHelper(Class aClass) {
        ClassLoader loader = aClass.getClassLoader();
        Object result = null;
        HashMap<Class, Object> hashMap = ourCache;
        synchronized (hashMap) {
            result = ourCache.get(aClass);
        }
        if (result == null) {
            result = ourNullObject;
            Class<IntrospectionHelper> helperClass = null;
            try {
                helperClass = loader != null ? loader.loadClass(IntrospectionHelper.class.getName()) : IntrospectionHelper.class;
                Method getHelperMethod = helperClass.getMethod("getHelper", Class.class);
                result = getHelperMethod.invoke(null, aClass);
            }
            catch (ClassNotFoundException e) {
                LOG.info((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.info((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.info((Throwable)e);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            HashMap<Class, Object> hashMap2 = ourCache;
            synchronized (hashMap2) {
                if (helperClass != null) {
                    AntIntrospector.clearAntStaticCache(helperClass);
                }
                ourCache.put(aClass, result);
            }
        }
        AntIntrospector.scheduleCacheCleaning();
        return result == ourNullObject ? null : result;
    }

    private static void clearAntStaticCache(Class helperClass) {
        try {
            Method method = helperClass.getDeclaredMethod("clearCache", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            try {
                Map helpersCollection = (Map)ReflectionUtil.getField((Class)helperClass, null, null, (String)"helpers");
                helpersCollection.clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void scheduleCacheCleaning() {
        ourCacheCleaner.cancelAllRequests();
        ourCacheCleaner.addRequest(() -> {
            HashMap<Class, Object> hashMap = ourCache;
            synchronized (hashMap) {
                ourCache.clear();
            }
        }, 10000);
    }
}

