/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class YAMLBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    private static final Language[] LANGUAGES = new Language[]{YAMLLanguage.INSTANCE};
    private static final int SCALAR_MAX_LENGTH = 20;

    public Language[] getLanguages() {
        return LANGUAGES;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "acceptElement"));
        }
        return e instanceof YAMLScalar || e instanceof YAMLKeyValue || e instanceof YAMLSequenceItem || e instanceof YAMLDocument;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getElementInfo"));
        }
        if (e instanceof YAMLDocument) {
            YAMLFile file = (YAMLFile)e.getContainingFile();
            if (file == null) {
                if ("Document" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getElementInfo"));
                }
                return "Document";
            }
            List<YAMLDocument> documents = file.getDocuments();
            String string = "Document " + YAMLBreadcrumbsInfoProvider.getIndexOf(documents, e);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getElementInfo"));
            }
            return string;
        }
        if (e instanceof YAMLKeyValue) {
            String string = ((YAMLKeyValue)e).getKeyText() + ':';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getElementInfo"));
            }
            return string;
        }
        if (e instanceof YAMLSequenceItem) {
            PsiElement parent = e.getParent();
            if (!(parent instanceof YAMLSequence)) {
                if ("Item" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getElementInfo"));
                }
                return "Item";
            }
            List<YAMLSequenceItem> items = ((YAMLSequence)parent).getItems();
            String string = "Item " + YAMLBreadcrumbsInfoProvider.getIndexOf(items, e);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getElementInfo"));
            }
            return string;
        }
        if (e instanceof YAMLScalar) {
            String string = StringUtil.first((String)((YAMLScalar)e).getTextValue(), (int)20, (boolean)true);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getElementInfo"));
            }
            return string;
        }
        throw new IllegalArgumentException("This element should not pass #acceptElement");
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getElementTooltip"));
        }
        return null;
    }

    @NotNull
    private static String getIndexOf(@NotNull List<?> list, Object o) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getIndexOf"));
        }
        String string = String.valueOf(1 + list.indexOf(o)) + '/' + list.size();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider", "getIndexOf"));
        }
        return string;
    }
}

