/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourceBundleEditorFileListener
extends VirtualFileAdapter {
    private final ResourceBundleEditor myEditor;
    private final MyVfsEventsProcessor myEventsProcessor;

    public ResourceBundleEditorFileListener(ResourceBundleEditor editor) {
        this.myEditor = editor;
        this.myEventsProcessor = new MyVfsEventsProcessor();
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener", "fileCreated"));
        }
        this.myEventsProcessor.queue(event, EventType.FILE_CREATED);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener", "fileDeleted"));
        }
        this.myEventsProcessor.queue(event, EventType.FILE_DELETED);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener", "propertyChanged"));
        }
        this.myEventsProcessor.queue((VirtualFileEvent)event, EventType.PROPERTY_CHANGED);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener", "contentsChanged"));
        }
        this.myEventsProcessor.queue(event, EventType.CONTENT_CHANGED);
    }

    private static class EventWithType {
        private final EventType myType;
        private final VirtualFileEvent myEvent;

        private EventWithType(EventType type, VirtualFileEvent event) {
            this.myType = type;
            this.myEvent = event;
        }

        public EventType getType() {
            return this.myType;
        }

        public VirtualFileEvent getEvent() {
            return this.myEvent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventWithType type = (EventWithType)o;
            if (this.myType != type.myType) {
                return false;
            }
            return this.myEvent.equals(type.myEvent);
        }

        public int hashCode() {
            int result = this.myType.hashCode();
            result = 31 * result + this.myEvent.hashCode();
            return result;
        }
    }

    private static enum EventType {
        FILE_CREATED,
        FILE_DELETED,
        CONTENT_CHANGED,
        PROPERTY_CHANGED;

    }

    private class SetViewerPropertyRunnable
    implements Runnable {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        private final List<Boolean> myIsViewer = new ArrayList<Boolean>();

        private SetViewerPropertyRunnable() {
        }

        public void addFile(VirtualFile virtualFile, boolean isViewer) {
            this.myFiles.add(virtualFile);
            this.myIsViewer.add(isViewer);
        }

        @Override
        public void run() {
            for (int i = 0; i < this.myFiles.size(); ++i) {
                VirtualFile file = this.myFiles.get(i);
                Boolean viewer = this.myIsViewer.get(i);
                EditorEx editor = ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().get(file);
                if (editor == null) continue;
                editor.setViewer(viewer.booleanValue());
            }
        }
    }

    private class MyVfsEventsProcessor {
        private final MergingUpdateQueue myMergeQueue;

        private MyVfsEventsProcessor() {
            this.myMergeQueue = new MergingUpdateQueue("rbe.vfs.listener.queue", 200, true, ResourceBundleEditorFileListener.this.myEditor.getComponent(), (Disposable)ResourceBundleEditorFileListener.this.myEditor, ResourceBundleEditorFileListener.this.myEditor.getComponent(), false){

                protected void execute(final @NotNull Update[] updates) {
                    if (updates == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updates", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$MyVfsEventsProcessor$1", "execute"));
                    }
                    ReadTask task = new ReadTask(){
                        private final EventWithType[] myEvents;
                        {
                            this.myEvents = (EventWithType[])Arrays.stream(updates).map(u -> (EventWithType)u.getEqualityObjects()[0]).toArray(EventWithType[]::new);
                        }

                        @Nullable
                        public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$MyVfsEventsProcessor$1$1", "performInReadAction"));
                            }
                            if (!ResourceBundleEditorFileListener.this.myEditor.isValid()) {
                                return null;
                            }
                            Runnable toDo = null;
                            for (EventWithType e : this.myEvents) {
                                NotNullLazyValue<Set<VirtualFile>> resourceBundleAsSet = new NotNullLazyValue<Set<VirtualFile>>(){

                                    @NotNull
                                    protected Set<VirtualFile> compute() {
                                        Set<VirtualFile> set = ResourceBundleEditorFileListener.this.myEditor.getResourceBundle().getPropertiesFiles().stream().map(PropertiesFile::getVirtualFile).collect(Collectors.toSet());
                                        if (set == null) {
                                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$MyVfsEventsProcessor$1$1$1", "compute"));
                                        }
                                        return set;
                                    }
                                };
                                if (e.getType() == EventType.FILE_DELETED || e.getType() == EventType.PROPERTY_CHANGED && ((VirtualFilePropertyEvent)e.getEvent()).getPropertyName().equals("name")) {
                                    if (!ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getEvent().getFile())) continue;
                                    toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                    break;
                                }
                                if (e.getType() == EventType.FILE_CREATED) {
                                    if (!((Set)resourceBundleAsSet.getValue()).contains(e.getEvent().getFile())) continue;
                                    toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                    break;
                                }
                                if (e.getType() == EventType.PROPERTY_CHANGED && ((VirtualFilePropertyEvent)e.getEvent()).getPropertyName().equals("writable")) {
                                    if (!ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getEvent().getFile())) continue;
                                    if (toDo == null) {
                                        toDo = new SetViewerPropertyRunnable();
                                    }
                                    if (toDo instanceof SetViewerPropertyRunnable) {
                                        ((SetViewerPropertyRunnable)toDo).addFile(e.getEvent().getFile(), (Boolean)((VirtualFilePropertyEvent)e.getEvent()).getNewValue() == false);
                                        continue;
                                    }
                                    toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                    break;
                                }
                                if (!ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getEvent().getFile())) continue;
                                if (toDo instanceof SetViewerPropertyRunnable) {
                                    toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                    break;
                                }
                                if (toDo != null) continue;
                                toDo = () -> ResourceBundleEditorFileListener.this.myEditor.updateEditorsFromProperties(true);
                            }
                            if (toDo == null) {
                                return null;
                            }
                            Runnable toDoCopy = toDo;
                            return new ReadTask.Continuation(() -> {
                                if (ResourceBundleEditorFileListener.this.myEditor.isValid()) {
                                    toDoCopy.run();
                                }
                            }, ModalityState.NON_MODAL);
                        }

                        public void onCanceled(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$MyVfsEventsProcessor$1$1", "onCanceled"));
                            }
                            for (EventWithType event : this.myEvents) {
                                this.queue(new MyUpdate(event));
                            }
                        }
                    };
                    ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)task);
                }
            };
        }

        public void queue(VirtualFileEvent event, EventType type) {
            this.myMergeQueue.queue((Update)new MyUpdate(new EventWithType(type, event)));
        }

        private class MyUpdate
        extends Update {
            public MyUpdate(EventWithType identity) {
                super((Object)identity);
            }

            public void run() {
                throw new IllegalStateException();
            }
        }
    }
}

