/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

class MutableTestExecutionSummary
implements TestExecutionSummary {
    final AtomicLong testsStarted = new AtomicLong();
    final AtomicLong testsFound = new AtomicLong();
    final AtomicLong testsSkipped = new AtomicLong();
    final AtomicLong testsAborted = new AtomicLong();
    final AtomicLong testsSucceeded = new AtomicLong();
    final AtomicLong testsFailed = new AtomicLong();
    private final TestPlan testPlan;
    private final List<Failure> failures = new ArrayList<Failure>();
    private final long timeStarted;
    long timeFinished;

    MutableTestExecutionSummary(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.testsFound.set(testPlan.countTestIdentifiers(TestIdentifier::isTest));
        this.timeStarted = System.currentTimeMillis();
    }

    void addFailure(TestIdentifier testIdentifier, Throwable throwable) {
        this.failures.add(new Failure(testIdentifier, throwable));
    }

    @Override
    public long getTestsStartedCount() {
        return this.testsStarted.get();
    }

    @Override
    public long getTestsFoundCount() {
        return this.testsFound.get();
    }

    @Override
    public long getTestsSkippedCount() {
        return this.testsSkipped.get();
    }

    @Override
    public long getTestsAbortedCount() {
        return this.testsAborted.get();
    }

    @Override
    public long getTestsSucceededCount() {
        return this.testsSucceeded.get();
    }

    @Override
    public long getTestsFailedCount() {
        return this.testsFailed.get();
    }

    @Override
    public long getTimeStarted() {
        return this.timeStarted;
    }

    @Override
    public long getTimeFinished() {
        return this.timeFinished;
    }

    @Override
    public void printTo(PrintWriter writer) {
        writer.println(String.format("%nTest run finished after %d ms\n[%10d tests found     ]\n[%10d tests skipped   ]\n[%10d tests started   ]\n[%10d tests aborted   ]\n[%10d tests successful]\n[%10d tests failed    ]\n", this.timeFinished - this.timeStarted, this.testsFound.get(), this.testsSkipped.get(), this.testsStarted.get(), this.testsAborted.get(), this.testsSucceeded.get(), this.testsFailed.get()));
        writer.flush();
    }

    @Override
    public void printFailuresTo(PrintWriter writer) {
        if (this.getTestsFailedCount() > 0L) {
            writer.println();
            writer.println(String.format("Test failures (%d):", this.testsFailed.get()));
            this.failures.forEach(failure -> {
                writer.println("  " + this.describeTest(failure.getTestIdentifier()));
                failure.getTestIdentifier().getSource().ifPresent(source -> writer.println("    " + source));
                writer.println("    => Exception: " + failure.getException().getLocalizedMessage());
            });
            writer.flush();
        }
    }

    private String describeTest(TestIdentifier testIdentifier) {
        ArrayList<String> descriptionParts = new ArrayList<String>();
        this.collectTestDescription(Optional.of(testIdentifier), descriptionParts);
        return descriptionParts.stream().collect(Collectors.joining(":"));
    }

    private void collectTestDescription(Optional<TestIdentifier> optionalIdentifier, List<String> descriptionParts) {
        optionalIdentifier.ifPresent(testIdentifier -> {
            descriptionParts.add(0, testIdentifier.getDisplayName());
            this.collectTestDescription(this.testPlan.getParent((TestIdentifier)testIdentifier), descriptionParts);
        });
    }

    private static class Failure {
        private final TestIdentifier testIdentifier;
        private final Throwable exception;

        Failure(TestIdentifier testIdentifier, Throwable exception) {
            this.testIdentifier = testIdentifier;
            this.exception = exception;
        }

        TestIdentifier getTestIdentifier() {
            return this.testIdentifier;
        }

        Throwable getException() {
            return this.exception;
        }
    }
}

