/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.palette.UIDesignerPaletteProvider;
import org.jetbrains.annotations.NotNull;

public class PaletteRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    private final UIDesignerPaletteProvider myUiDesignerPaletteProvider;

    public PaletteRefactoringListenerProvider(UIDesignerPaletteProvider uiDesignerPaletteProvider) {
        this.myUiDesignerPaletteProvider = uiDesignerPaletteProvider;
    }

    public RefactoringElementListener getListener(PsiElement element) {
        ComponentItem item;
        PsiClass psiClass;
        String oldName;
        if (element instanceof PsiClass && (oldName = ClassUtil.getJVMClassName((PsiClass)(psiClass = (PsiClass)element))) != null && (item = Palette.getInstance(element.getProject()).getItem(oldName)) != null) {
            return new MyRefactoringElementListener(item);
        }
        return null;
    }

    private class MyRefactoringElementListener
    extends RefactoringElementAdapter {
        private final ComponentItem myItem;

        public MyRefactoringElementListener(ComponentItem item) {
            this.myItem = item;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/uiDesigner/palette/PaletteRefactoringListenerProvider$MyRefactoringElementListener", "elementRenamedOrMoved"));
            }
            PsiClass psiClass = (PsiClass)newElement;
            String qName = ClassUtil.getJVMClassName((PsiClass)psiClass);
            if (qName != null) {
                this.myItem.setClassName(qName);
                PaletteRefactoringListenerProvider.this.myUiDesignerPaletteProvider.fireGroupsChanged();
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/uiDesigner/palette/PaletteRefactoringListenerProvider$MyRefactoringElementListener", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/uiDesigner/palette/PaletteRefactoringListenerProvider$MyRefactoringElementListener", "undoElementMovedOrRenamed"));
            }
            this.myItem.setClassName(oldQualifiedName);
            PaletteRefactoringListenerProvider.this.myUiDesignerPaletteProvider.fireGroupsChanged();
        }
    }
}

