/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.CommonBundle;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.wizard.BeanStep;
import com.intellij.uiDesigner.wizard.BindCompositeStep;
import com.intellij.uiDesigner.wizard.Generator;
import com.intellij.uiDesigner.wizard.WizardData;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class DataBindingWizard
extends AbstractWizard<StepAdapter> {
    private final WizardData myData;
    private final Project myProject;
    private final BeanStep myBeanStep;

    public DataBindingWizard(@NotNull Project project, @NotNull WizardData data) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uiDesigner/wizard/DataBindingWizard", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/uiDesigner/wizard/DataBindingWizard", "<init>"));
        }
        super(UIDesignerBundle.message("title.data.binding.wizard", new Object[0]), project);
        this.myProject = project;
        this.myData = data;
        this.myBeanStep = new BeanStep(this.myData);
        this.addStep((Step)this.myBeanStep);
        this.addStep((Step)new BindCompositeStep(this.myData));
        this.init();
        if (!data.myBindToNewBean) {
            this.doNextAction();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBeanStep.myTfShortClassName;
    }

    protected void doOKAction() {
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                Generator.generateDataBindingMethods(this.myData);
                DataBindingWizard.super.doOKAction();
            }
            catch (Generator.MyException exc) {
                Messages.showErrorDialog((Component)this.getContentPane(), (String)exc.getMessage(), (String)CommonBundle.getErrorTitle());
            }
        }), "", null);
    }

    protected String getHelpID() {
        return "guiDesigner.formCode.dataBind";
    }
}

