/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.writer.KCode;
import java.util.ArrayList;
import java.util.List;

public class BracketExpr
extends Expr {
    private BracketAccessor mAccessor;

    BracketExpr(Expr target, Expr arg) {
        super(target, arg);
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        ModelClass targetType = this.getTarget().getResolvedType();
        if (targetType.isArray()) {
            this.mAccessor = BracketAccessor.ARRAY;
        } else if (targetType.isList()) {
            this.mAccessor = BracketAccessor.LIST;
        } else if (targetType.isMap()) {
            this.mAccessor = BracketAccessor.MAP;
        } else {
            throw new IllegalArgumentException("Cannot determine variable type used in [] expression. Cast the value to List, Map, or array. Type detected: " + targetType.toJavaCode());
        }
        return targetType.getComponentType();
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        List<ExecutionPath> targetPaths = this.getTarget().toExecutionPath(paths);
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>();
        if (this.getTarget() instanceof StaticIdentifierExpr) {
            result.addAll(this.toExecutionPathInOrder(paths, this.getTarget()));
        } else {
            for (ExecutionPath path : targetPaths) {
                ComparisonExpr cmp = this.getModel().comparison("!=", this.getTarget(), this.getModel().symbol("null", Object.class));
                path.addPath(cmp);
                ExecutionPath subPath = path.addBranch(cmp, true);
                if (subPath == null) continue;
                List<ExecutionPath> argPath = this.getArg().toExecutionPath(subPath);
                result.addAll(this.addJustMeToExecutionPath(argPath));
            }
        }
        return result;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            if (dependency.getOther() != this.getTarget()) continue;
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        String targetKey = this.getTarget().computeUniqueKey();
        return this.addTwoWay(BracketExpr.join(targetKey, "$", this.getArg().computeUniqueKey(), "$"));
    }

    @Override
    public String getInvertibleError() {
        return null;
    }

    public Expr getTarget() {
        return this.getChildren().get(0);
    }

    public Expr getArg() {
        return this.getChildren().get(1);
    }

    public BracketAccessor getAccessor() {
        return this.mAccessor;
    }

    public boolean argCastsInteger() {
        return this.mAccessor != BracketAccessor.MAP && this.getArg().getResolvedType().isObject();
    }

    @Override
    protected KCode generateCode(boolean expand) {
        String cast = this.argCastsInteger() ? "(Integer) " : "";
        switch (this.getAccessor()) {
            case ARRAY: {
                return new KCode().app("getFromArray(", this.getTarget().toCode()).app(", ").app(cast, this.getArg().toCode()).app(")");
            }
            case LIST: {
                ModelClass listType = ModelAnalyzer.getInstance().findClass(List.class).erasure();
                ModelClass targetType = this.getTarget().getResolvedType().erasure();
                if (listType.isAssignableFrom(targetType)) {
                    return new KCode().app("getFromList(", this.getTarget().toCode()).app(", ").app(cast, this.getArg().toCode()).app(")");
                }
                return new KCode().app("", this.getTarget().toCode()).app(".get(").app(cast, this.getArg().toCode()).app(")");
            }
            case MAP: {
                return new KCode().app("", this.getTarget().toCode()).app(".get(", this.getArg().toCode()).app(")");
            }
        }
        throw new IllegalStateException("Invalid BracketAccessor type");
    }

    @Override
    public KCode toInverseCode(KCode value) {
        String cast = this.argCastsInteger() ? "(Integer) " : "";
        return new KCode().app("setTo(", this.getTarget().toCode(true)).app(", ").app(cast, this.getArg().toCode(true)).app(", ", value).app(");");
    }

    public static enum BracketAccessor {
        ARRAY,
        LIST,
        MAP;

    }
}

