/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.writer.KCode;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.util.ArrayList;
import java.util.List;

public class ListenerExpr
extends Expr {
    private final String mName;
    private final ModelClass mListenerType;
    private final ModelMethod mMethod;

    ListenerExpr(Expr expr, String name, ModelClass listenerType, ModelMethod method) {
        super(expr);
        this.mName = name;
        this.mListenerType = listenerType;
        this.mMethod = method;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return this.mListenerType;
    }

    public ModelMethod getMethod() {
        return this.mMethod;
    }

    public Expr getChild() {
        return this.getChildren().get(0);
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isDynamic() {
        return this.getChild().isDynamic();
    }

    @Override
    protected List<Dependency> constructDependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Dependency dependency = new Dependency(this, this.getChild());
        dependency.setMandatory(true);
        dependencies.add(dependency);
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        return ListenerExpr.join(this.getResolvedType().getCanonicalName(), this.getChild().computeUniqueKey(), this.mName);
    }

    @Override
    public KCode generateCode(boolean expand) {
        KCode code = new KCode("(");
        int minApi = Math.max(this.mListenerType.getMinApi(), this.mMethod.getMinApi());
        if (minApi > 1) {
            code.app("(getBuildSdkInt() < " + minApi + ") ? null : ");
        }
        String fieldName2 = LayoutBinderWriterKt.getFieldName(this);
        String listenerClassName2 = LayoutBinderWriterKt.getListenerClassName(this);
        KCode value = this.getChild().toCode();
        code.app("((").app(fieldName2).app(" == null) ? (").app(fieldName2).app(" = new ").app(listenerClassName2).app("()) : ").app(fieldName2).app(")");
        if (this.getChild().isDynamic()) {
            code.app(".setValue(", value).app(")");
        }
        code.app(")");
        return code;
    }

    @Override
    public String getInvertibleError() {
        return "Listeners cannot be the target of a two-way binding";
    }
}

