/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.solver;

import android.databinding.tool.expr.Expr;
import android.databinding.tool.solver.ExecutionBranch;
import android.databinding.tool.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionPath {
    @Nullable
    private final Expr mExpr;
    @NotNull
    private List<ExecutionPath> mChildren = new ArrayList<ExecutionPath>();
    @Nullable
    private ExecutionBranch mTrueBranch;
    @Nullable
    private ExecutionBranch mFalseBranch;
    private Map<Expr, Boolean> mKnownValues = new HashMap<Expr, Boolean>();
    private Set<Expr> mScopeExpressions = new HashSet<Expr>();
    private final boolean mIsAlreadyEvaluated;

    public static ExecutionPath createRoot() {
        return new ExecutionPath(null, false);
    }

    private ExecutionPath(@Nullable Expr expr, boolean isAlreadyEvaluated) {
        this.mExpr = expr;
        this.mIsAlreadyEvaluated = isAlreadyEvaluated;
    }

    @Nullable
    public ExecutionPath addBranch(Expr pred, boolean expectedValue) {
        Preconditions.checkNull(expectedValue ? this.mTrueBranch : this.mFalseBranch, "Cannot add two " + expectedValue + "branches", new Object[0]);
        Boolean knownValue = this.mKnownValues.get(pred);
        if (knownValue != null) {
            if (expectedValue == knownValue) {
                return this.addPath(null);
            }
            return null;
        }
        ExecutionPath path = this.createPath(null);
        ExecutionBranch edge = new ExecutionBranch(path, pred, expectedValue);
        path.mKnownValues.put(pred, expectedValue);
        if (expectedValue) {
            if (this.mFalseBranch != null) {
                Preconditions.check(this.mFalseBranch.getConditional() == pred, "Cannot add branches w/ different conditionals.", new Object[0]);
            }
            this.mTrueBranch = edge;
        } else {
            if (this.mTrueBranch != null) {
                Preconditions.check(this.mTrueBranch.getConditional() == pred, "Cannot add branches w/ different conditionals.", new Object[0]);
            }
            this.mFalseBranch = edge;
        }
        return path;
    }

    private ExecutionPath createPath(@Nullable Expr expr) {
        ExecutionPath path = new ExecutionPath(expr, expr == null || this.mScopeExpressions.contains(expr));
        path.mKnownValues.putAll(this.mKnownValues);
        path.mScopeExpressions.addAll(this.mScopeExpressions);
        return path;
    }

    @NotNull
    public ExecutionPath addPath(@Nullable Expr expr) {
        Preconditions.checkNull(this.mFalseBranch, "Cannot add path after branches are set", new Object[0]);
        Preconditions.checkNull(this.mTrueBranch, "Cannot add path after branches are set", new Object[0]);
        ExecutionPath path = this.createPath(expr);
        if (expr != null) {
            this.mScopeExpressions.add(expr);
            path.mScopeExpressions.add(expr);
        }
        this.mChildren.add(path);
        return path;
    }

    public void debug(StringBuilder builder, int offset) {
        this.offset(builder, offset);
        if (this.mExpr != null || !this.mIsAlreadyEvaluated) {
            builder.append("expr:").append(this.mExpr == null ? "root" : this.mExpr.getUniqueKey());
            builder.append(" isRead:").append(this.mIsAlreadyEvaluated);
        } else {
            builder.append("branch");
        }
        if (!this.mKnownValues.isEmpty()) {
            builder.append(" I know:");
            for (Map.Entry entry : this.mKnownValues.entrySet()) {
                builder.append(" ");
                builder.append(((Expr)entry.getKey()).getUniqueKey());
                builder.append(" is ").append(entry.getValue());
            }
        }
        for (ExecutionPath executionPath : this.mChildren) {
            builder.append("\n");
            executionPath.debug(builder, offset);
        }
        if (this.mTrueBranch != null) {
            this.debug(builder, this.mTrueBranch, offset);
        }
        if (this.mFalseBranch != null) {
            this.debug(builder, this.mFalseBranch, offset);
        }
    }

    @Nullable
    public Expr getExpr() {
        return this.mExpr;
    }

    @NotNull
    public List<ExecutionPath> getChildren() {
        return this.mChildren;
    }

    @Nullable
    public ExecutionBranch getTrueBranch() {
        return this.mTrueBranch;
    }

    @Nullable
    public ExecutionBranch getFalseBranch() {
        return this.mFalseBranch;
    }

    public boolean isAlreadyEvaluated() {
        return this.mIsAlreadyEvaluated;
    }

    private void debug(StringBuilder builder, ExecutionBranch branch, int offset) {
        builder.append("\n");
        this.offset(builder, offset);
        builder.append("if ").append(branch.getConditional().getUniqueKey()).append(" is ").append(branch.getExpectedCondition()).append("\n");
        branch.getPath().debug(builder, offset + 1);
    }

    private void offset(StringBuilder builder, int offset) {
        for (int i = 0; i < offset; ++i) {
            builder.append("  ");
        }
    }

    public Map<Expr, Boolean> getKnownValues() {
        return this.mKnownValues;
    }
}

